(**************************************************************************)
(*                                                                        *)
(*  Web server input stream handler                                       *)
(*  Copyright (C) 2024   Peter Moylan                                     *)
(*                                                                        *)
(*  This program is free software: you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation, either version 3 of the License, or     *)
(*  (at your option) any later version.                                   *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful,       *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *)
(*  GNU General Public License for more details.                          *)
(*                                                                        *)
(*  You should have received a copy of the GNU General Public License     *)
(*  along with this program.  If not, see <http://www.gnu.org/licenses/>. *)
(*                                                                        *)
(*  To contact author:   http://www.pmoylan.org   peter@pmoylan.org       *)
(*                                                                        *)
(**************************************************************************)

IMPLEMENTATION MODULE TLSCompression;

        (********************************************************)
        (*                                                      *)
        (* Interface between TLS and the compression algorithms *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            5 April 2018                    *)
        (*  Last edited:        18 August 2025                  *)
        (*  Status:             OK                              *)
        (*                                                      *)
        (********************************************************)


FROM TLSBase IMPORT
    (* type *)  TextType;

(************************************************************************)
(*                            METHOD SUPPORTED                          *)
(************************************************************************)

PROCEDURE CompressionSupported (N: CARDINAL): CompressionMethod;

    (* Returns the compression method if method N supported,    *)
    (* otherwise returns nocompression.                         *)

    BEGIN
        RETURN nocompression;
    END CompressionSupported;

(************************************************************************)
(*                            COMPRESSION                               *)
(************************************************************************)

PROCEDURE Compress (method: CompressionMethod;
                        VAR (*INOUT*) buffer: TextType);

    (* Replaces buffer with a compressed version. *)

    BEGIN
        (* Since the only method we support is nocompression, this      *)
        (* is a no-op.                                                  *)
    END Compress;

(************************************************************************)
(*                            COMPRESSION                               *)
(************************************************************************)

PROCEDURE Decompress (method: CompressionMethod;
                        VAR (*INOUT*) buffer: TextType);

    (* Reverses the compression. *)

    BEGIN
        (* Since the only method we support is nocompression, this      *)
        (* is a no-op.                                                  *)
    END Decompress;

(************************************************************************)

END TLSCompression.

