/* StartGnuplot.cmd , startgp.cmd */

/*
   Utility to _temporarily_ set the necessary environment variables for
   gnuplot in the same directory of this utility.
   You may start it from an arbitrary directory then.
   It passes all command line parameters to the gnuplot executable.
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysloadFuncs

Parse Arg param
Parse Source os env full_name

if param == '""' then
  param = ''

call setlocal
bindir   = FileSpec("path", full_name)
bindrive = FileSpec("drive", full_name)
binpath  = bindrive || bindir
p = lastpos('\', strip(binpath, 'T', '\'))
gproot   = left(binpath, p)
binpath  = strip(binpath, 'T', '\')
env      = 'ENVIRONMENT'

call set_env 'GNUPLOT', binpath
call append_env 'GNUPLOT_LIB', gproot || "demo;" || gproot || "demo/games"

/* pm terminal defaults */
if get_env("GNUTERM") == "" then
  call set_env "GNUTERM", "pm wide ps 2 lw 2"

/* customise png/jpeg/gif terminals */
call append_env 'GDFONTPATH', "C:/PSFONTS;C:/OS2/MDOS/WINOS2/SYSTEM"
call set_env 'GNUPLOT_DEFAULT_GDFONT', "Times"

/* make sure we load our own DLLs */
call value 'LIBPATHSTRICT', 'T', env
/* The value function does not work for BEGINLIBPATH */
call SysSetExtLibPath binpath || ';' || SysQueryExtLibPath('B'), 'B'

/* the actual call to gnuplot */
'@'binpath'\gnuplot.exe 'param
call endlocal
exit


append_env:
  if value(arg(1),, env) = "" then
    call value arg(1), arg(2), env
  else
    call value arg(1), arg(2) || ";" || value(arg(1),, env), env
  return

prefix_env:
  if value(arg(1),, env) = "" then
    call value arg(1), arg(2), env
  else
     call value arg(1), value(arg(1),, env) || ";" || arg(2), env
  return

set_env:
  if value(arg(1),, env) = "" then
    call value arg(1), arg(2), env
  return

get_env:
  return value(arg(1),, env)
