/* ********************************************************************* */
/* FILE: gif.h */
/* function: ANSI C headerfile for GIF Image compression routines */
/* ********************************************************************* */


/* General DEFINEs */
#define min(a,b)        ((a>b) ? b : a)

#define BITS	12

#define HSIZE  5003		/* 80% occupancy */

/* Pointer to function returning an int */
typedef int (*ifunptr) ();

/* a code_int must be able to hold 2**BITS values of type int, and also -1 */
typedef int code_int;

#ifdef SIGNED_COMPARE_SLOW
typedef unsigned long int count_int;
typedef unsigned short int count_short;
#else
typedef long int count_int;
#endif

#ifdef NO_UCHAR
typedef char char_type;
#else
typedef unsigned char char_type;
#endif				/* UCHAR */

/* gifcompr.c */
void compress (int init_bits, FILE * outfile, ifunptr ReadValue);
void
  output (code_int code);
void
  cl_block (void);
void
  cl_hash (count_int hsize);
void
  writeerr (void);
void
  char_init (void);
void
  char_out (int c);
void
  flush_char (void);

/* gifencod.c */
void
  BumpPixel (void);
int GIFNextPixel (ifunptr getpixel);
void
GIFEncode (char *FName, int GWidth, int GHeight, int GInterlace, int Background,
     int BitsPerPixel, int Red[], int Green[], int Blue[], ifunptr GetPixel);
void
  Putword (int w, FILE * fp);
int GetPixel (int x, int y);

/* ************************************************************** */
/* END OF FILE */
/* ************************************************************** */
