.TH BLOCKMEDIAN l "1 August 1995"
.SH NAME
blockmedian \- filter to block average (x,y,z) data by L1 norm.
.SH SYNOPSIS
\fBblockmedian\fP [ \fIxyz[w]file(s)\fP ] \fB\-I\fP\fIx_inc\fP[m|c][/\fIy_inc\fP[m]]  
\fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] [ \fB\-H\fP ] [ \fB\-N\fP ] [ \fB\-V\fP ] 
[ \fB\-W\fP[\fBio\fP] ] [ \fB\-:\fP ] [ \fB\-b\fP[\fBi|o\fP][\fBd\fP] ]
.SH DESCRIPTION
blockmedian reads arbitrarily located (x,y,z) triples [or optionally weighted
quadruples (x,y,z,w)] from standard input [or \fIxyz[w]file(s)\fP] and writes to standard output a median position and
value for every non-empty block in a grid region defined by the \fB\-R\fP and \fB\-I\fP arguments.
Either \fBblockmean\fP or \fBblockmedian\fP should be used as a pre-processor before running \fBsurface\fP to avoid
aliasing short wavelengths.  These routines are also  generally useful for decimating or averaging
(x,y,z) data.  You can modify the
precision of the output format by editing the D_FORMAT parameter in your .gmtdefaults file, or
you may choose binary input and/or output using single or double precision storage.
.TP
\fIxyz[w]file(s)\fP
3 [or 4] column ASCII file(s) [or binary, see \fB\-b\fP] holding (x,y,z [w]) data values.  [w] is an optional weight for the data.
If no file is specified, blockmedian will read from standard input.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the block size. Append m to indicate minutes or c to indicate seconds.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.sp
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
Not used with binary data.
.TP
.B \-N
Offsets the grid registration of the boxes.  Use pixel registration instead of grid registration.
By default, the centers of the blocks coincide with the defined
lattice nodes; each block contains all points nearest to a lattice node.  The \fB\-N\fP option will offset
the blocks so their edges coincide with the lattice lines. For example, suppose the arguments are \fB\-R\fP10/15/10/15
and \fB\-I\fP1  This defines a 6 x 6 block array; the lower left block will average data within 9.5 <= (x,y) < 10.5.
If the same lattice is given with the \fB\-N\fP option, the block array is 5 x 5 and the lower left block will average
the data within 10 <= (x,y) < 11.  The default registration is normally used for preprocessing and gridding map data.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Weighted modifier[s].  Unweighted input and output has 3 columns x,y,z; Weighted i/o has 4 columns x,y,z,w.
Weights can be used in input to construct weighted median values in blocks.  Weight sums can be reported in
output for later combining several runs, etc.  Use \fB\-W\fP for weighted i/o, \fB\-Wi\fP for weighted input
only, \fB\-Wo\fP for weighted output only.  [Default uses unweighted i/o]
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-b
Selects binary input and output mode.  Append \fBi\fP or \fBo\fP to select single precision binary input or output only.
[Default is ASCII].  Append \fBd\fP to indicate double precision for binary data (if both binary input and output are
selected they will have the same precision).
.SH EXAMPLES
To find 5 by 5 minute block medians from the double precision binary data in hawaii_b.xyg and output an ASCII table, try
.sp
blockmedian hawaii_b.xyg \fB\-R\fP198/208/18/25 \fB\-I\fP5m \fB\-b\fPid > hawaii_5x5.xyg
.SH SEE ALSO
blockmean, gmt, gmtdefaults, nearneighbor, surface, triangulate
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
