.TH FILTER1D l "1 August 1995"
.SH NAME
filter1d \- Time domain filtering of 1-D time series
.SH SYNOPSIS
\fBfilter1d\fP [ \fIinfile\fP ] \fB\-F\fP\fI<type><width>\fP [ \fB\-D\fP\fIincrement\fP ]  
[ \fB\-E\fP ] [ \fB\-H\fP ] [ \fB\-I\fP\fIignore_val\fP ] [ \fB\-L\fP\fIlack_width\fP ] 
[ \fB\-N\fP\fIn_cols/t_col\fP ] [ \fB\-Q\fP\fIq_factor\fP ] [ \fB\-S\fP\fIsymmetry_factor\fP ] 
[ \fB\-T\fP\fIstart/stop/int\fP ] [ \fB\-V\fP ] [ \fB\-b\fP[\fBi|o\fP][\fBd\fP] ]
.SH DESCRIPTION
filter1d is a general time domain filter for multiple column time series data.
The user specifies the number of columns of input and which column is the time.
(See \fB\-N\fP option below).  The fastest operation occurs when the input time series are
equally spaced and have no gaps or outliers and the special options are not needed.
filter1d has options L, Q, and S for unevenly sampled data with gaps.
.TP
\fIinfile\fP
Multi-column ASCII file holding data values to be filtered.
.TP
.B \-F
sets Filtertype, \fItype\fP is one of \fBb\fP(oxcar), \fBc\fP(osine arch), \fBg\fP(aussian), \fBm\fP(edian),
or \fBp\fP(maximum likelihood Probability estimator -- a mode estimator),
and specify full filter \fIwidth\fP in same units as time column,
OR, use \fB\-Ff\fP\fIname\fP to give the name of a one-column file of your own coefficients.
Upper case type \fBB, C, G, M, P, F\fP will use robust filter versions:
i.e., replace outliers (2.5 L1 scale off median) with median during filtering.
.SH OPTIONS
.sp
.TP
.B \-D
\fIincrement\fP is used when series is NOT equidistantly sampled.
Then \fIincrement\fP will be the abscissae resolution, i.e., all abscissae
will be rounded off to a multiple of \fIincrement\fP.  Alternatively, resample
data with \fBsample1d\fP.
.TP
.B \-E
Include Ends of time series in output.  Default loses half the filter-width of data at each end.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
To ignore values; If an input value equals \fIignore_val\fP it will be set to NaN.
.TP
.B \-L
Checks for Lack of data condition.  If input data has a gap exceeding
\fIwidth\fP then no output will be given at that point [Default does not check Lack].
.TP
.B \-N
Sets number of columns in input and which column contains the independent
variable (time). The left-most column is # 0, the right-most is # (\fIn_cols\fP - 1).
[Default is \fIn_cols\fP = 2, \fIt_col\fP = 0; i.e., file has t, f(t) pairs].
.TP
.B \-Q
assess Quality of output value by checking mean weight in convolution.
Enter \fIq_factor\fP between 0 and 1.  If mean weight < \fIq_factor\fP, output is suppressed
at this point [Default does not check Quality].
.TP
.B \-S
Checks symmetry of data about window center.  Enter a factor
between 0 and 1.  If ( (abs(n_left - n_right)) / (n_left + n_right) ) > \fIfactor\fP,
then no output will be given at this point [Default does not check Symmetry].
.TP
.B \-T
Make evenly spaced timesteps from \fIstart\fP to \fIstop\fP by \fIint\fP [Default uses input times].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-b
Selects binary input and output mode.  Append \fBi\fP or \fBo\fP to select single precision binary input or output only
[Default is ASCII].  Append \fBd\fP to indicate double precision for binary data (if both binary input and output are
selected they will have the same precision).
.SH EXAMPLES
To filter the data set in the file cruise.gmtd containing evenly spaced gravity, magnetics, topography,
and distance (in m) with a 10 km Gaussian filter, removing outliers, and output a filtered
value every 2 km between 0 and 100 km, try
.br
.sp
filter1d cruise.gmtd \fB\-T\fP0/1.0e5/2000 \fB\-F\fPG10000 \fB\-N\fP4/3 \fB\-V\fP > filtered_cruise.gmtd
.br
.sp
Data along track often have uneven sampling and gaps which we do not want to interpolate using \fBsample1d\fP.
To find the median depth in a 50 km window every 25 km along the track of cruise v3312, stored in v3312.dt,
checking for gaps of 10km and asymmetry of 0.3, try
.br
.sp
filter1d v3312.dt \fB\-F\fPM50 \fB\-T\fP0/100000/25 \fB\-L\fP10 \fB\-S\fP0.3 > v3312_filt.dt
.SH SEE ALSO
gmt, sample1d
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
