.TH FITCIRCLE l "1 August 1995"
.SH NAME
fitcircle \- find mean position and pole of best-fit great [or small] circle to points on a sphere.
.SH SYNOPSIS
\fBfitcircle\fP [ \fIxyfile\fP ] \fB\-L\fP\fInorm\fP [ \fB\-H\fP ] [ \fB\-S\fP ] [ \fB\-V\fP ] [ \fB\-:\fP ]
.SH DESCRIPTION
\fBfitcircle\fP reads ascii lon,lat [or lat,lon] values from the first two columns on standard input 
[or \fIxyfile\fP].  These are converted to cartesian three-vectors on the unit sphere.  Then two 
locations are found:  the mean of the input positions, and the pole to the great circle which 
best fits the input positions.  The user may choose one or both of two possible solutions to this 
problem.  The first is called \fB\-L1\fP and the second is called \fB\-L2\fP.  When the data are 
closely grouped along a great circle both solutions are similar.  If the data have large dispersion, 
the pole to the great circle will be less well determined than the mean.  Compare both solutions as 
a qualitative check.
.br
.sp
The \fB\-L1\fP solution is so called because it approximates the minimization of the sum of absolute 
values of cosines of angular distances.  This solution finds the mean position as the Fisher average 
of the data, and the pole position as the Fisher average of the cross-products between the mean and 
the data.  Averaging cross-products gives weight to points in proportion to their distance from the 
mean, analogous to the "leverage" of distant points in linear regression in the plane.
.sp
The \fB\-L2\fP solution is so called because it approximates the minimization of the sum of squares 
of cosines of angular distances.  It creates a 3 by 3 matrix of sums of squares of components of the 
data vectors.  The eigenvectors of this matrix give the mean and pole locations.  This method may 
be more subject to roundoff errors when there are thousands of data.  The pole is given by the eigenvector 
corresponding to the smallest eigenvalue; it is the least-well represented factor in the data and is 
not easily estimated by either method.
.br
.sp
.TP
.B \-L
\fInorm\fP Specify the desired norm as 1 or 2, or use \fB\-L\fP or  \fB\-L3\fP to see both solutions.
.SH OPTIONS
.sp
.TP
\fIxyfile\fP
ASCII file containing lon,lat [lat,lon] values in the first 2 columns.  If no file is specified, \fBfitcircle\fP 
will read from standard input.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-S
Attempt to fit a small circle instead of a great circle.  The pole will be
constrained to lie on the great circle connecting the pole of the best-fit great circle
and the mean location of the data.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.SH EXAMPLES
Suppose you have lon,lat,grav data along a somewhat twisty ship track in the file ship.xyg.  You want to 
project this data onto a great circle and resample it in distance, in order to filter it or check its spectrum.  
Try this:  
.sp
\fBfitcircle\fP ship.xyg \fB\-L\fP2 
.sp
\fBproject\fP ship.xyg \fB\-O\fP\fIox\fP/\fIoy\fP \fB\-P\fP\fIpx\fP/\fIpy\fP \fB\-S\fP \fB\-pz\fP | sample1d \fB\-S\fP\-100 \fB\-I\fP1 
> output.pg
.sp
In this example, \fIox\fP/\fIoy\fP is the lon/lat of the mean from \fBfitcircle\fP, and \fIpx\fP/\fIpy\fP is the lon/lat 
of the pole.  The file output.pg has distance, gravity data sampled every 1 km along the great circle which best fits ship.xyg
.SH SEE ALSO
gmt, project, sample1d
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
