.TH GRD2CPT l "1 August 1995"
.SH NAME
grd2cpt \- Read a grdfile and make a color palette file
.SH SYNOPSIS
\fBgrd2cpt\fP \fIgrdfile\fP [ \fB\-C\fP\fIminhue/maxhue\fP ] [ \fB\-L\fP\fIminlimit/maxlimit\fP ] 
 [ \fB\-M\fP\fImingray/maxgray\fP ] [ \fB\-S\fP\fIzstart/zstop/zinc\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrd2cpt\fP reads a grdfile and writes a color palette (cpt) file to standard output.  
The cpt file has continuously changing hue (or gray level) and the mapping from 
data value to hue (or gray level) is through the data's cumulative distribution 
function (CDF), so that the colors are histogram equalized.  Thus if the resulting 
cpt file is used with the grdfile and grdimage with a linear projection, the colors 
will be uniformly distributed in area on the plot.  A simple linear transform from 
data to hue (or gray level) is not provided here because that can be made with 
\fBmakecpt\fP or \fBawk\fP.
Let z be the data values in the grdfile.  Define CDF(Z) = (# of z < Z) / (# of z in 
grdfile).  (NaNs are ignored).  Then hue(Z) = \fIminhue\fP + (\fImaxhue - minhue\fP) * 
CDF(Z), or the equivalent with \fImingray/maxgray\fP.
.TP
\fIgrdfile\fP
The 2-D binary grdfile used to derive the color palette table.
.SH OPTIONS
.TP
.B \-C
Color option.  Set hues to use at lowest (\fIminhue\fP) and highest (\fImaxhue\fP) 
end of cpt range.  [Default is 300/0, i.e. magenta/red]. 
.TP
.B \-L
Limit range of cptfile to \fIminlimit/maxlimit\fP, and don't count data outside range 
when estimating CDF(Z).  [Default uses min and max of data.] 
.TP
.B \-M
Monochrome option.  Set gray levels (on a scale from 0=black to 1=white) to use at 
lowest (\fImingray\fP) and highest (\fImaxgray\fP) end of cpt range.  [Default is 
color output.] 
.TP
.B \-S
Set steps in cpt file.  Calculate entries in cptfile from \fIzstart\fP to \fIzstop\fP
in steps of (\fIzinc\fP).  [Default chooses arbitrary values by a crazy scheme.] 
.TP
.B \-V
Verbose operation.  This will write CDF(Z) estimates to stderr.  [Default is silent.] 
.SH EXAMPLES
Sometimes you don't want to make a cpt file (yet) but would find it helpful to know
that 90% of your data lie between z1 and z2, something you cannot learn from \fBgrdinfo\fP.  
So you can do this to see some points on the CDF(Z) curve (use \fB\-V\fP option to see more):
.br
.sp
grd2cpt mydata.grd -V > /dev/null
.br
.sp
To make a cpt file with entries from 0 to 200 in steps of 20, and ignore data below 
zero in computing CDF(Z), and use hues from dark purple (260) to orange (30), try
.br
.sp
grd2cpt mydata.grd \fB\-C\fP260/30 \fB-L\fP0/10000 \fB-S\fP0/200/20 > mydata.cpt
.SH SEE ALSO
gmtdefaults, gmt, grdhisteq, grdinfo, makecpt
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
