.TH GRD2XYZ l "1 August 1995"
.SH NAME
grd2xyz \- Converting a grdfile to an ASCII or binary table
.SH SYNOPSIS
\fBgrd2xyz\fP \fIgrdfile\fP [ \fB\-Z\fP ] [ \fB\-b\fP[\fBd\fP] ]
.SH DESCRIPTION
\fBgrd2xyz\fP reads a binary 2-D grdfile and writes out xyz-triplets in ASCII [or binary] format to standard output.
The ASCII file can be edited using any text editor.  You can modify the
precision of the ASCII output format by editing the D_FORMAT parameter in your .gmtdefaults file, or
you may choose binary output using single or double precision storage.  As an option you may output the
z-values without the (x,y) pair assuming scanline orientation.
.TP
\fIgrdfile\fP
The 2-D binary file to be converted.
.SH OPTIONS
.TP
.B \-Z
Only write a 1-column ASCII [or binary] table using the scanline ordering convention.
.TP
.B \-b
Selects binary output mode [Default is ASCII].  Append \fBd\fP for double precision [Default is single].
.SH EXAMPLES
To edit individual values in the 5' by 5' hawaii_grv.grd file, try
.br
.sp
grd2xyz hawaii_grv.grd > hawaii_grv.xyz
.br
.sp
To write a single precision binary file without the x,y positions from the file raw_data.grd file, try
.br
.sp
grd2xyz raw_data.grd \fB\-Z \-b\fP > hawaii_grv.b
.SH SEE ALSO
gmtdefaults, gmt, grdedit, xyz2grd
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
