.TH GRDCLIP l "1 Aug 1993"
.SH NAME
grdclip \- Clipping of range in grdfiles.
.SH SYNOPSIS
\fBgrdclip\fP \fIinput_file.grd\fP \fB\-G\fP\fIoutput_file.grd\fP [ \fB\-A\fP\fIhigh/above\fP ] 
[ \fB\-B\fP\fIlow/below\fP ] [ \fB\-V\fP ] 
.SH DESCRIPTION
\fBgrdclip\fP will set values < \fIlow\fP to \fIbelow\fP and/or values > \fIhigh\fP to \fIabove\fP.  Useful
when you want all of a continent or an ocean to fall into one color or grayshade in image processing,
or clipping of the range of data values is required.  \fIabove/below\fP can be any number or NaN (Not a Number).
You must choose at least one of \fB\-A\fP or \fB\-B\fP.
.TP
\fIinput_file.grd\fP
The input 2-D binary grdfile.
.TP
.B \-G
\fIoutput_file.grd\fP is the modified output grdfile.
.SH OPTIONS
.TP
.B \-A
Set all data[i] > \fIhigh\fP to \fIabove\fP.
.TP
.B \-B
Set all data[i] < \fIlow\fP to \fIbelow\fP.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To set all values > 70 to NaN and all values < 0 to 0 in file data.grd, try:
.sp
grdclip data.grd \fB\-G\fPnew_data.grd \fB\-A\fP70/NaN \fB\-B\fP0/0 \fB\-V\fP
.SH SEE ALSO
gmt, grdlandmask, grdmask, grdmath, grd2xyz, xyz2grd
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
