.TH GRDCONTOUR l "1 August 1995"
.SH NAME
grdcontour \- contouring of 2-D gridded data sets
.SH SYNOPSIS
\fBgrdcontour\fP \fIgrdfile\fP \fB\-C\fP\fIcont_int\fP \fB\-J\fP\fIparameters\fP [ \fB\-A\fP\fIanot_int\fP[\fBf\fP\fIfont_size\fP][\fBa\fP\fIangle\fP][\fI/r/g/b\fP][o]] ] 
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-D\fP\fIdumpfile\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-G\fP\fIgap/width\fP ] 
[ \fB\-K\fP ] [ \fB\-L\fP\fIlow/high\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Q\fP\fIcut\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] ] 
[ \fB\-S\fP\fIsmoothfactor\fP ] [ \fB\-T\fP[+|-][\fIgap/length\fP][:LH] ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V \fP ] [ \fB\-W\fP\fItype\fP[\fIpen\fP] ] 
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIfactor\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBgrdcontour\fP reads a 2-D gridded file and produces a contour map by tracing
each contour through the grid.  As an option, the x/y/z positions of the contour lines may be dumped to
a single multisegment file or many separate files.  \fIPostScript\fP code is generated and sent to standard output.  Various options
that affect the plotting are available.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIgrdfile\fP
2-D gridded data set to be contoured
.TP
.B \-C
The contours to be drawn may be specified in one of three possible ways:
.br
If \fIcont_int\fP has the suffix ".cpt" and can be opened as a file, it is assumed
to be a color palette table.  The color boundaries are then used as contour levels.
If the cpt-file has anotation flags in the last column then those contours will be
anotated.  By default no contours are labeled; use \fB\-A\fP to anotate all contours.
.br
If \fIcont_int\fP is a file but not a cpt-file, it is expected to contain contour levels
in column 1 and a C(ontour) OR A(nnotate) in col 2. The levels marked C (or c) are contoured,
the levels marked A (or a) are contoured and annotated.  Optionally, a third column may be
present and contain the fixed anotation angle for this contour level.
.br
If no file is found, then \fIcont_int\fP is
interpreted as a constant contour interval.  If \fB\-A\fP is set and \fB\-C\fP is not, then
the contour interval is set equal to the specified anotation interval.
.br
If a file is given and \fB\-T\fP is set, 
then only contours marked with upper case C or A will have tickmarks.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
\fIanot_int\fP is annotation interval in data units.  Ignored if contour levels are given in a file.
[Default is no annotations].  Several options can be set to modify the form of the annotation.  Append f\fIfont_size\fP to change font size [9], append \fI/r/g/b\fP to change color of text fill box
[PAGE_COLOR], append a\fIangle\fP to fix annotation angle [Default follows contour], and append 'o' to draw the outline of the surrounding text box [Default is no outline].
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-D
Dump the (x,y,z) coordinates of each contour to separate files, one for each contour segment. The
files will be named \fIdumpfile_cont_segment[_i]\fP.xyz, where \fIcont\fP is the contour value and
\fIsegment\fP is a running segment number for each contour interval (for closed contours we append _i.)
However, when \fB\-M\fP
is used in conjunction with \fB\-D\fP a single multisegment file is created instead.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation for perspective view [180/90]
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is black]
.TP
.B \-G
\fIgap\fP is distance in inch between each annotation along the same contour.
\fIwidth\fP is number of points over which to estimate the best fitting slope
for contour labels  [Default is 4/10].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Limit range: Do not draw contours for data values below \fIlow\fP or above \fIhigh\fP.
.TP
.B \-M
When used in conjunction with \fB\-D\fP a single multisegment file is created, and
each contour section is preceeded by a header record whose first column is \fIflag\fP
followed by the contour level.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-Q
Do not draw contours with less than \fIcut\fP number of points [Draw all contours].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
[Default is region defined in the grd file].
.TP
.B \-S
Used to resample the contour lines at roughly every (gridbox_size/\fIsmoothfactor\fP) interval.
.TP
.B \-T
Will draw tickmarks pointing in the downward direction every \fIgap\fP along the innermost closed contours.  Append \fIgap\fP and tickmark length (in inch) or use defaults [0.2/0.05].
User may choose to tick only local highs or local lows by specifying \fB\-T+\fP or \fB\-T-\fP, respectively.  Appending :LH will plot the characters L and H at the center of closed
innermost contours (local lows and highs).  L and H can be any single character (e.g., LH, -+, etc.)
If a file is given by \fB\-C\fP and \fB\-T\fP is set, 
then only contours marked with upper case C or A will have tickmarks [and anotation].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
\fItype\fP, if present, can be 'a' for annotated contours or 'c' for regular contours [Default].
\fIpen\fP sets the attributes for the particular line.  Default values for annotated contours:
width = 3, color = black, texture = solid.  Regular contours have default width = 1.
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-Z
Use to multiply data values by \fIfactor\fP before contouring starts.
(Numbers in \fB\A, \-C, \-L\fP refer to values after this scaling has occurred.)
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To contour the file hawaii_grav.grd every 25 mGal on a Mercator map at 0.5 inch/degree, annotate
every 50 mGal (using fontsize = 10), using 1 degree tickmarks, and draw 30 minute gridlines, try 
.br
.sp
grdcontour hawaii_grav.grd \fB\-Jm\fP0.5 \fB\-C\fP25 \fB\-A\fP50f10 \fB\-B\fP1g30m > hawaii_grav.ps
.br
.sp
To contour the file image.grd using the levels in the file cont.d on a linear projection at 0.1 inch/x-unit
and 50 inch/y-unit, using 20 (x) and 0.1 (y) tickmarks, smooth the contours a bit, use "RMS Misfit" as
plot-title, use a thick red pen for annotated contours, and a thin, dashed, blue pen for the rest, try 
.br
.sp
grdcontour image.grd \fB\-Jx\fP0.1/50.0 \fB\-C\fPcont.d \fB\-S\fP4 \fB\-B\fP20/0.1:."RMS Misfit":
\fB\-W\fPa5/255/0/0 \fB\-W\fPc1/0/0/255ta | lpr
.SH BUGS
The text-outline box has not been implemented for perspective view plots.  Anotations will plot correctly, but contours will go right through the text.
.br
The labeling of local highs and lows may plot outside the innermost contour since only the mean value
of the contour coordinates is used to position the label.
.br
There are too many options.
.SH SEE ALSO
gmt, psbasemap, grdimage, grdview, pscontour
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
