.TH GRDEDIT l "1 August 1995"
.SH NAME
grdedit \- Modifying the header in a 2-D grdfile
.SH SYNOPSIS
\fBgrdedit\fP \fIgrdfile\fP [\fB\-D\fP\fIxunit/yunit/zunit/scale/offset/title/remark\fP] 
[ \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] ] [\fB\-S\fP ]
.SH DESCRIPTION
\fBgrdedit\fP reads the header information in a binary 2-D grdfile and replaces
the information with values provided on the command line [if any].  As an option,
global, geographical grids (with 360 degrees longitude range) can be rotated in
the east-west direction.  \fBgrdedit\fP only operates on files containing a grdheader.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIgrdfile\fP
Name of the 2-D grdfile to modify
.sp
.SH OPTIONS
.TP
.B \-D
Give new values for \fIxunit, yunit, zunit, scale, offset, title,\fP and \fIremark\fP.
To leave some of the values untouched, specify = as the new value.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-S
For global, geographical grids only.  Grid values will be shifted laterally according to
the new borders given in \fB\-R\fP.
.SH EXAMPLES
Let us assume the file data.grd covers the area 300/310/10/30.  We want
to change the boundaries from geodetic longitudes to geographic and put a new title in
the header.  We accomplish this by
.br
.sp
grdedit data.grd \fB\-R\fP-60/-50/10/30 \fB\-D\fP=/=/=/=/=/"Gravity Anomalies"/=
.br
.sp
The grid world.grd has the limits 0/360/-72/72.  To shift the
data so that the limits would be -180/180/-72/72, use
.br
.sp
grdedit world.grd \fB\-R\fP-180/180/-72/72 \fB\-S\fP
.SH SEE ALSO
gmt, grd2xyz, xyz2grd
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
