.TH GRDGRADIENT l "1 August 1995"
.SH NAME
grdgradient \- Compute directional gradients from 2-D grd files 
.SH SYNOPSIS
\fBgrdgradient\fP \fIin_grdfile\fP \fB\-A\fP\fIazim\fP \fB\-G\fP\fIout_grdfile\fP 
[ \fB\-M\fP ] [ \fB\-N\fP[t][\fInorm\fP] ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdgradient\fP may be used to compute the directional derivative of a
grdfile representing z(x,y).  The program finds -[dz/dx*sin(\fIazim\fP) + dz/dy*
cos(\fIazim\fP)], where \fIazim\fP is an angle (in degrees) in the x,y plane measured
positive clockwise from north (the y axis) toward east (the x axis).  The
derivative is negated so that \fBgrdgradient\fP will give positive values when
the slope of z(x,y) is downhill in the \fIazim\fP direction.  The reason for this
is that most applications for \fBgrdgradient\fP are in shading the illumination
of an image (see \fBgrdimage\fP and \fBgrdview\fP), and if we take the light source to be above the
x,y plane then slopes which are downhill toward the light source are bright (positive)
while slopes which are uphill toward the light source are dark (negative).
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIin_grdfile\fP
2-D grd file from which to compute directional derivative.
.TP
.B \-A
Azimuthal direction.  \fIazim\fP is the angle (in degrees) in the x,y plane measured
positive clockwise from north (the y axis) toward east (the x axis).
.TP
.B \-G
Name of the output grdfile with directional derivative.
.br
.sp
.SH OPTIONS
.TP
.B \-M
By default the units of \fBgrdgradient\fP are in units_of_z/units_of_dx_and_dy.
However, the user may choose this option to convert dx,dy in degrees of
longitude,latitude into meters, so that the units of \fBgrdgradient\fP are in
z_units/meter.
.TP
.B \-N
This option will scale and offset all the actual gradient values by a
constant scale and offset so that the maximum absolute value of the 
output is \fInorm\fP.
By default, no normalization is done.  If \fB\-N\fP or \fB\-Nt\fP is 
chosen without setting the value of \fInorm\fP, then the gradients 
are normalized to 1.0.
If \fB\-Nt\fP is chosen, then the gradients are adjusted to be 
(2 * \fInorm\fP / PI) * atan( (g - m)/s), where g is the gradient, 
m is the mean gradient and s the standard deviation.  This is 
often a good first choice for an intensity file to be used with 
\fBgrdimage\fP or \fBgrdview\fP.  Further adjustments to gradients for intensities may 
be made with \fBgrdmath\fP or \fBgrdhisteq\fP.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To find the atan-normalized directional derivative of the file geoid.grd in the north direction, do
.br
.sp
grdgradient geoid.grd \fB\-A\fP0 \fB\-G\fPgradients.grd \fB\-Nt \-V\fP
.br
.sp
To get the gradient of the scalar field z.grd we take the gradient in the negative
x- and y-directions (because of the sign convention above) and obtain the two components
of grad (z) which can be plotted with \fBgrdvector\fP:
.br
.sp
grdgradient z.grd \fB\-A\fP270 \fB\-G\fPdzdx.grd
.br
grdgradient z.grd \fB\-A\fP180 \fB\-G\fPdzdy.grd
.br
.SH SEE ALSO
gmt, gmtdefaults, grdhisteq, grdimage, grdview, grdvector
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
