.TH GRDIMAGE l "1 August 1995"
.SH NAME
grdimage \- Create grayshaded or colored image from a 2-D netCDF grd file
.SH SYNOPSIS
\fBgrdimage\fP \fIgrdfile\fP \fB\-C\fP\fIcptfile\fP \fB\-J\fP\fIparameters\fP 
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-E\fP\fIdpi\fP ] [ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-I\fP\fIintensfile\fP] [ \fB\-K\fP ] 
[ \fB\-M\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V \fP ] [ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] 
[ \fB\-c\fP\fIcopies\fP ] [ \fB\-0\fP || \fB\-1\fP || \fB\-2\fP ]
.SH DESCRIPTION
\fBgrdimage\fP reads a 2-D gridded file and produces a gray-shaded (or colored) map by assigning
each contour interval a gray-shade (or color).  Optionally, illumination may be added by providing
a file with intensities in the (-1,+1) range.  Values outside this range will be clipped.
Such intensity files can be created from the
grdfile using \fBgrdgradient\fP and modified by \fBgrdmath\fP or \fBgrdhisteq\fP.  Each grid-node in the
grdfile is represented as a shaded (or colored) rectangle centered on the grid node.  When using map projections,
the grid is first resampled on a new rectangular grid  (This can be a time-consuming process for large grid files).
A 24-bit true color \fIPostScript\fP file is output using one of three methods.
The region option can be used to select a map region larger or smaller than that implied by the extent of the
grdfile.
.TP
\fIgrdfile\fP
2-D gridded data set to be imaged
.TP
.B \-C
name of the color palette table
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-E
Sets the resolution of the projected grid that will be created if
a map projection other than Linear or Mercator was selected.  By default,
the projected grid will be of the same size (rows and columns) as the
input file.
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is black]
.TP
.B \-I
Gives the name of a grdfile with intensities in the (-1,+1) range. [Default is no illumination].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Force conversion to monochrome image using the (television) YIQ transformation.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
You may ask for a larger \fIw/e/s/n\fP region to have more room between the image and the axes.
A smaller region than specified in the grdfile will result in a subset of the grid [Default is
region given by the grdfile].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.TP
.B \-0
Create the image using the Adobe \fIPostScript\fP colorimage operator.  This is the
GMT default (which can be modified in the .gmtdefaults file).
.TP
.B \-1
Create the image by plotting individually colored tiles.
.TP
.B \-2
Create the image by color separation using three calls to image for later
processing by \fBpsto24\fP.
.SH EXAMPLES
To gray-shade the file hawaii_grav.grd with shades given in shades.cpt on a Lambert map
at 0.5 inch/degree along the standard parallels 18 and 24, and using 1 degree tickmarks, try 
.br
.sp
grdimage hawaii_grav.grd \fB\-Jl\fP18/24/0.5 \fB\-C\fPshades.cpt \fB\-B\fP1 > hawaii_grav_image.ps
.br
.sp
To create an illuminated color \fIPostScript\fP plot of the gridded data set image.grd, using the
intensities provided by the file intens.grd, and color
levels in the file colors.cpt, with linear scaling at 10 inch/x-unit, tickmarks every 5 units, and
using color separations for use with \fBpsto24\fP, try
.br
.sp
grdimage image.grd \fB\-Jx\fP10 \fB\-C\fPcolors.cpt \fB\-I\fPintens.grd \fB\-B\fP5 \fB\-2\fP > image.ps
.SH BUGS
Having three separate ways of creating the colorimage comes from the fact that many different
implementations of the colorimage \fIPostScript\fP operator exists for a wide variety of
hardcopy devices.  The three options allow you to create the type of output required by your RIP.
.SH SEE ALSO
gmt, grdcontour, grdview, grdgradient, grdhisteq, ps2ras, psto24
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
