.TH GRDINFO l "1 August 1995"
.SH NAME
grdinfo \- Get information about the contents of a 2-D grd file
.SH SYNOPSIS
\fBgrdinfo\fP \fIgrdfiles\fP [ \fB\-L1\fP ] [ \fB\-L2\fP ] [ \fB\-M\fP ]
.SH DESCRIPTION
\fBgrdinfo\fP reads a 2-D binary grd file and reports various statistics for the (x,y,z) data in the
grdfile.  The output information contains the minimum/maximum values for x, y, and z, where the
min/max of z occur, the x- and y-increments, and the number of x and y nodes, and
[optionally] the mean, standard deviation, and/or the median, L1 scale of z, and number of nodes set to NaN.
.TP
\fIgrdfile\fP
The name of one or several 2-D grd files.
.br
.sp
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-L1
Report median and L1 scale of z (L1 scale = 1.4826 * Median Absolute Deviation (MAD)).
.TP
.B \-L2
Report mean and standard deviation of z.
.TP
.B \-M
Search for and report the location of min/max z-values, and count and report the number of nodes
set to NaN, if any.
.SH EXAMPLES
To obtain all the information about the data set in file hawaii_topo.grd, try
.br
.sp
grdinfo \fB\-L1 \-L2 \-M\fP hawaii_topo.grd
.SH SEE ALSO
gmt, grd2cpt, grd2xyz, grdedit
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
