.TH GRDLANDMASK l "1 August 1995"
.SH NAME
grdlandmask \- Create "wet-dry" mask grdfile from shoreline data base.
.SH SYNOPSIS
\fBgrdlandmask\fP \fB\-G\fP\fImask_grd_file\fP] \fB\-I\fP\fIxinc\fP[m|c][/\fIyinc\fP[m|c]] 
\fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] [ \fB\-A\fP\fImin_area/max_level\fP ] [ \fB\-D\fP\fIresolution\fP ] [ \fB\-F\fP ] [ \fB\-N\fP\fImaskvalues\fP[o] ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdlandmask\fP reads the selected shoreline database and uses that information to decide which
nodes in the specified grid are over land or over water.  The nodes defined by
the selected region and lattice spacing will be set according to one of two criteria:
(1) Lands vs water, or (2) the more detailed (hierarchial) ocean vs land vs lake vs island vs pond.  The
resulting mask grdfile may be used in subsequent operations involving \fBgrdmath\fP to mask out
data from land [or water] areas.
.TP
.B \-G
Name of resulting output mask grd file.
.TP
.B \-I
\fIxinc\fP [and optionally \fIyinc\fP] is the grid spacing. Append m to indicate minutes, c to indicate seconds.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.TP
.B \-A
Features with an area smaller than \fImin_area\fP in km^2 or of hierarchical level higher than \fImax_level\fP
will be ignored [Default is 0/4 (all features)]. See DATABASE INFORMATION in the \fBpscoast\fP man-pages for more details.
.TP
.B \-D
Selects the resolution of the data set to use ((\fBf\fP)ull, (\fBh\fP)igh, (\fBi\fP)ntermediate, (\fBl\fP)ow, or (\fBc\fP)rude).  The
resolution drops off by ~80% between data sets. [Default is \fBl\fP].
.TP
.B \-F
Force pixel registration.  [Default is grid registration].
.TP
.B \-N
Sets the values that will be assigned to nodes.  Values can be any number, including the
textstring NaN.  Append o to let nodes exactly on feature boundaries be considered outside [Default is inside].
Specify this information using 1 of 2 formats:
.br
	\fB\-N\fP\fIwet/dry\fP.
.br
	\fB\-N\fP\fIocean/land/lake/island/pond\fP.
.br
[Default is 0/1/0/1/0 (i.e., 0/1)].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To set all nodes on land to NaN, and nodes over water to 1, using the high resolution data set, do
.br
.sp
grdlandmask \fB\-R\fP-60/-40/-40/-30 \fB\-D\fPh  \fB\-I\fP5m \fB\-N\fPNaN/1 \fB\-G\fPland_mask.grd \fB\-V\fP
.br
.sp
To make a 1x1 degree global grid with the hierarchical levels of the nodes based on the low resolution data, try
.br
.sp
grdlandmask \fB\-R\fP0/360/-90/90 \fB\-D\fPl  \fB\-I\fP1 \fB\-N\fP0/1/2/3/4 \fB\-G\fPlevels.grd \fB\-V\fP
.br
.SH SEE ALSO
gmt, grdmath, grdclip, psmask, psclip, pscoast
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
