.TH GRDMASK l "1 August 1995"
.SH NAME
grdmask \- Create mask grdfiles from xy paths.
.SH SYNOPSIS
\fBgrdmask\fP \fIpathfiles\fP \fB\-G\fP\fImask_grd_file\fP] \fB\-I\fP\fIxinc\fP[m|c][/\fIyinc\fP[m|c]] 
\fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] [ \fB\-F\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP\fIout/edge/in\fP ] [ \fB\-V\fP ]  [ \fB\-:\fP ]
.SH DESCRIPTION
\fBgrdmask\fP reads one or more xy-files that each define a closed polygon.  The nodes defined by
the specified region and lattice spacing will be set equal to one of three possible values
depending if the node is outside, on the polygon perimeter, or inside the polygon.  The
resulting mask grdfile may be used in subsequent operations involving \fBgrdmath\fP to mask out
data from polygonal areas.
.TP
\fIpathfiles\fP
The name of 1 or more ASCII files holding the polygon(s).
.TP
.B \-G
Name of resulting output mask grd file.
.TP
.B \-I
\fIxinc\fP [and optionally \fIyinc\fP] is the grid spacing. Append m to indicate minutes, c to indicate seconds.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.TP
.B \-F
Force pixel registration.  [Default is grid registration].
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Sets the values that will be assigned to nodes that are \fIout\fPside the polygons,
on the \fIedge\fP, or \fIin\fPside.  Values can be any number, including the
textstring NaN  [Default is 0/0/1].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To set all nodes inside and on the polygons coastline_*.xy to 0, and outside points
to 1, do
.sp
grdmask coastline_*.xy \fB\-R\fP-60/-40/-40/-30 \fB\-I\fP5m \fB\-N\fP1/0/0 \fB\-G\fPland_mask.grd  \fB\-V\fP
.SH SEE ALSO
gmt, grdlandmask, grdmath, grdclip, psmask, psclip
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
