.TH GRDMATH l "1 August 1995"
.SH NAME
grdmath \- Reverse Polish calculator for grd files
.SH SYNOPSIS
\fBgrdmath\fP [ \fB\-I\fP\fIxinc\fP[m|c][/\fIyinc\fP[m|c]] \fB\-R\fP\fIwest/east/south/north\fP \fB\-V\fP] 
\fIoperand\fP [ \fIoperand\fP ] \fBOPERATOR\fP [ \fIoperand\fP ] \fBOPERATOR\fP ... \fB=\fP \fIoutgrdfile\fP
.SH DESCRIPTION
\fBgrdmath\fP will perform operations like add, subtract, multiply, and divide on one or more grd files or constants using
Reverse Polish syntax (e.g., Hewlett-Packard calculator-style).  Arbitrarily complicated expressions may therefore
be evaluated; the final result is written to an output grd file. When two grd files are
on the stack, each element in file A is modified by the corresponding element in file B.
However, some operators only require one operand (see below).  If no grdfiles are used in the
expression then options \fB\-R, \-I\fP must be set (and optionally \fB\-F\fP).
.TP
\fIoperand\fP
If \fIoperand\fP can be opened as a file it will be read as a grd file.  If not a file, it is interpreted
as a numerical constant or a special symbol (see below).
.TP
\fIoutgrdfile\fP is a 2-D grd file that will hold the final result.
.TP
.B OPERATORS
Choose among the following operators:
.br
Operator		n_args	Returns
.br
.sp
\fBABS\fP		1	abs (A).
.br
\fBACOS\fP		1	acos (A).
.br
\fBACOSH\fP		1	acosh (A).
.br
\fBADD(+)\fP		2	A + B.
.br
\fBAND\fP		2	NaN if A and B == NaN, B if A == NaN, else A.
.br
\fBASIN\fP		1	asin (A).
.br
\fBASINH\fP		1	asinh (A).
.br
\fBATAN\fP		1	atan (A).
.br
\fBATAN2\fP		2	atan2 (A, B).
.br
\fBATANH\fP	1	atanh (A).
.br
\fBCEIL\fP		1	ceil (A) (smallest integer >= A).
.br
\fBCOS\fP		1	cos (A).
.br
\fBCOSH\fP		1	cosh (A).
.br
\fBDIV(/)\fP		2	A / B.
.br
\fBDUP\fP		1	Places duplicate of A on the stack.
.br
\fBEXCH\fP		2	Exchanges A and B on the stack.
.br
\fBEXP\fP		1	exp (A).
.br
\fBFLOOR\fP		1	floor (A) (greatest integer <= A).
.br
\fBFMOD\fP		2	A % B (remainder).
.br
\fBHYPOT\fP		2	hypot (A, B).
.br
\fBINV\fP		1	1 / A.
.br
\fBLOG\fP		1	log (A) (natural log).
.br
\fBLOG10\fP		1	log10 (A).
.br
\fBMAX\fP		2	maximum of A and B.
.br
\fBMEAN\fP		1	Mean value of A.
.br
\fBMED\fP		1	Median value of A.
.br
\fBMIN\fP		2	minimum of A and B.
.br
\fBMUL(x)\fP		2	A * B.
.br
\fBNEG\fP		1	-A.
.br
\fBOR\fP		2	NaN if A or B == NaN, else A.
.br
\fBPOW(^)\fP		2	A ^ B.
.br
\fBR2\fP		2	R2 = A^2 + B^2.
.br
\fBRINT\fP		1	rint (A) (nearest integer).
.br
\fBSIGN\fP		1	sign (+1 or -1) of A.
.br
\fBSIN\fP		1	sin (A).
.br
\fBSINH\fP		1	sinh (A).
.br
\fBSQRT\fP		1	sqrt (A).
.br
\fBSTD\fP		1	Standard deviation of A.
.br
\fBSUB(-)\fP		2	A - B.
.br
\fBTAN\fP		1	tan (A).
.br
\fBTANH\fP		1	tanh (A).
.br
.TP
.B SYMBOLS
The following symbols have special meaning:
.br
.sp
\fBPI\fP	3.1415926...
.br
\fBE \fP	2.7182818...
.br
\fBX \fP	Grid with x-coordinates
.br
\fBY \fP	Grid with y-coordinates
.br
.SH OPTIONS
.TP
.B \-I
\fIxinc\fP [and optionally \fIyinc\fP] is the grid spacing. Append m to indicate minutes, c to indicate seconds.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-F
Select pixel registration.  [Default is grid registration].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To multiply test.grd by 10.0, try 
.br
	grdmath test.grd 10.0 \fBMUL =\fP test10.grd
.br
.sp
To take log10 of the average of 2 files, use
.br
	grdmath file1.grd file2.grd \fBADD\fP 0.5 \fBMUL LOG10 =\fP file3.grd
.br
.sp
Given the file ages.grd, which holds seafloor ages in m.y., use the relation
depth(in m) = 2500 + 350 * sqrt (age) to estimate normal seafloor depths:
.br
	grdmath ages.grd \fBSQRT\fP 350 \fBMUL \fP2500 \fBADD =\fP depths.grd
.br
.sp
To find the angle a (in degrees) of the largest principal stress from the stress tensor given by the
three files s_xx.grd s_yy.grd, and s_xy.grd from the relation tan (2*a) = 2 * s_xy / (s_xx - s_yy), try
.br
	grdmath 2 s_xy.grd \fBMUL\fP s_xx.grd s_yy.grd \fBSUB DIV ATAN2\fP 2 \fBDIV =\fP direction.grd
.SH BUGS
Files that has the same name as some operators, e.g., ADD, SIGN, =, etc. cannot be read
and must not be present in the current directory.  Piping of files are not allowed.
The stack limit is hard-wired to 50.
.SH SEE ALSO
gmt, grd2xyz, grdedit, grdinfo, xyz2grd
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
