.TH GRDPASTE l "1 August 1995"
.SH NAME
grdpaste \- Paste together two \fI.grd\fP files along a common edge.
.SH SYNOPSIS
\fBgrdpaste\fP \fB\-A\fP\fIfile_a.grd\fP \fB\-B\fP\fIfile_b.grd\fP \fB\-G\fP\fIoutfile.grd\fP 
[ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdpaste\fP will combine \fIfile_a.grd\fP and \fIfile_b.grd\fP into \fIoutfile.grd\fP by pasting
them together along their common edge.  Files A and B must have the same dx, dy and have one edge
in common.  If in doubt, check with \fBgrdinfo\fP and use \fBgrdcut\fP and/or \fBgrdsample\fP
if necessary to prepare the edge joint.
.TP
\fB\-A\fP\fIfile_a.grd\fP
One of two files to be pasted together.
.TP
\fB\-B\fP\fIfile_b.grd\fP
The other of two files to be pasted together.
.TP
\fB\-G\fP\fIoutfile.grd\fP
The name for the combined output.
.SH OPTIONS
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
Suppose file_a.grd is 150E - 180E and 0 - 30N, and file_b.grd is 150E - 180E, -30S - 0, then you can
make outfile.grd which will be 150 - 180 and -30S - 30N by: 
.sp
grdpaste \fB\-A\fPfile_a.grd \fB\-B\fPfile_b.grd \fB\-G\fPoutfile.grd \fB\-V\fP
.SH SEE ALSO
gmt, grdcut, grdinfo, grdsample
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
