.TH GRDPROJECT l "1 August 1995"
.SH NAME
grdproject \- Forward and Inverse map transformation of 2-D grd files 
.SH SYNOPSIS
\fBgrdproject\fP \fIin_grdfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fIwest/east/south/north\fP[\fIr\fP] 
[ \fB\-D\fP\fIdx\fP[m|c][/\fIdy\fP[m|c]] ] [ \fB\-E\fP\fIdpi\fP ] [ \fB\-F\fP ] [ \fB\-G\fP\fIout_grdfile\fP ] [ \fB\-I\fP ] 
[ \fB\-N\fP\fInx/ny\fP ] [ \fB\-S\fP\fIsearch_radius\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdproject\fP will do one of two things depending whether \fB\-I\fP has been set.  If set, it
will transform a gridded data set from a rectangular coordinate system onto a geographical
system by resampling the surface at the new nodes.  If not set, it will project a geographical
gridded data set onto a rectangular grid.  The new nodes are filled based on a simple weighted
average of nearby points.  Aliasing is avoided by using sensible values for the \fIsearch_radius\fP.
The new node spacing may be determined in one of several ways by specifying the grid spacing,
number of nodes, or resolution.  Nodes not constrained by input data are set to NaN.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIin_grdfile\fP
2-D binary grd file to be transformed.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.TP
.B \-D
Set the grid spacing for the new grid.  Append m for minutes, c for seconds.
.TP
.B \-E
Set the resolution for the new grid in dots pr inch.
.TP
.B \-F
Force pixel registration [Default is grid registration].
.TP
.B \-G
Specify the name of the output netCDF grd file.
.TP
.B \-I
Do the Inverse transformation, from rectangular to geographical.
.TP
.B \-N
Set the number of grid nodes in the new grid.
.TP
.B \-S
Set the search radius for the averaging procedure  [Default avoids aliasing].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To transform the geographical grid dbdb5.grd onto a pixel Mercator grid at 300 dpi, run
.br
.sp
grdproject dbdb5.grd \fB\-R\fP20/50/12/25 \fB\-Jm\fP0.25 \fB\-E\fP300 \fB\-F\fP
\fB\-G\fPdbdb5_merc.grd 
.br
.sp
To inversely transform the file topo_tm.grd back onto a geographical grid try
.br
.sp
grdproject topo_tm.grd \fB\-R\fP-80/-70/20/40 \fB\-Jt\fP-75/1:500000 \fB\-I\fP \fB\-D\fP5m \fB\-V\fP \fB\-G\fPtopo.grd
.br
.SH RESTRICTIONS
The boundaries of a projected (rectangular) data set will not necessarily give rectangular
geographical boundaries (Mercator is one exception).  In those cases some nodes may be unconstrained (set to NaN).
To get a full grid back, your input grid may have to cover a larger area than you are interrested in.
.SH SEE ALSO
gmt, gmtdefaults, mapproject
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
