.TH GRDREFORMAT l "1 August 1995"
.SH NAME
grdreformat \- Converting between different grdfile formats.
.SH SYNOPSIS
\fBgrdreformat\fP \fIingrdfile\fP[\fI=id\fP[\fI/scale/offset\fP[\fI/nanvalue\fP]]] \fIoutgrdfile\fP[\fI=id\fP[\fI/scale/offset\fP[\fI/nanvalue\fP]]] 
[ \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdreformat\fP reads a grdfile in one format and writes it out using another format.  As an option the
user may select a subset of the data to be written and to specify scaling, translation, and nan-value.
.TP
\fIingrdfile\fP
The grdfile to be read.  Append format =\fIid\fP number if not a standard GMT netcdf-based grdfile.
If \fIid\fP is set, you may optionally append \fIscale\fP and \fIoffset\fP to scale the data and then add an offset.  If \fIscale\fP and \fIoffset\fP
are supplied you may also append a value that represent 'not-a-number' (for floating-point grids this
is unneccesary since the IEEE NaN is used; however short integers need a value which means no data available.)
.TP
\fIoutgrdfile\fP
The grdfile to be written.  Append format =\fIid\fP number if not a standard GMT netcdf-based grdfile.
If \fIid\fP is set, you may optionally append \fIscale\fP and \fIoffset\fP to scale the data and then add an offset.  If \fIscale\fP and \fIoffset\fP
are supplied you may also append a value that represent 'not-a-number' (for floating-point grids this
is unneccesary since the IEEE NaN is used; however short integers need a value which means no data available.)
.SH OPTIONS
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To create a 4-byte raw floating point grid from the netcdf file data.grd, try
.br
.sp
grdreformat \fIdata.grd ras_data.b4=1\fP \fB\-V\fP
.br
.sp
To make a 2-byte short integer file and scale it by 10 and subtract 32000, letting
NaNs be represented by the value -9999, do
.br
.sp
grdreformat \fIvalues.grd shorts.i2=2/10/-32000/-9999\fP \fB\-V\fP
.br
.sp
To create a Sun standard 8-bit rasterfile for a subset of the data file image.grd,
assuming the range in image.grd is 0-1 and we need 0-255, try
.br
.sp
grdreformat \fIimage.grd\fP \fB\-R\fP-60/-40/-40/-30 \fIimage.ras8=3/255/0 \fB\-V\fP
.SH SEE ALSO
gmt, grdmath
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
