.TH GRDSAMPLE l "1 August 1995"
.SH NAME
grdsample \- Resample a grd file onto a new grid
.SH SYNOPSIS
\fBgrdsample\fP \fIin_grdfile\fP \fB\-G\fP\fIout_grdfile\fP [ \fB\-F\fP ] [ \fB\-I\fP\fIdx\fP[m|c][/\fIdy\fP[m|c]] ] 
[ \fB\-L\fP ] [ \fB\-N\fP\fInx/ny\fP ] [ \fB\-Q\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] ] [ \fB\-T\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdsample\fP reads a 2-D binary grd file and resamples it on a new grid
specified by either a new number of nodes or a new grid-spacing.  A sub-region may also
be selected.  A bicubic [Default] or bilinear interpolation
is used to sample the grid.  Free
boundary conditions are assumed (curvature and 3rd normal derivative is zero).  \fBgrdsample\fP
is mostly used to resample a grid onto a finer grid.  Going the other way will
introduce aliasing and is better done using \fBgrdfft\fP or \fBgrdfilter\fP.
.TP
\fIin_grdfile\fP
The name of the input 2-D binary grd file.
.TP
.B \-G
The name of the output grd file.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-F
Force pixel registration.  [Default is grid registration].
.TP
.B \-I
Sets the new grid spacing.  Append \fBm\fP for minutes, or c for seconds.
.TP
.B \-L
Indicates that the input grdfile is a geographical grid.
.TP
.B \-Q
Quick mode, use bilinear rather than bicubic interpolation.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-T
Translates between pixel registration and gridline registration.  If input data
is gridline registered, then output will be a pixel grid, and vice versa.  The
input file's \fB\-R\fP and \fB\-I\fP are used so no other options are necessary
(except possibly \fB\-Q\fP).
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To resample the 5 x 5 minute grid in hawaii_5by5_topo.grd onto a 1 minute grid, try
.br
.sp
grdsample hawaii_5by5_topo.grd \fB\-I\fP1m \fB\-G\fPhawaii_1by1_topo.grd
.br
.sp
To translate the gridline-registered file surface.grd to pixel registration, try
.br
.sp
grdsample surface.grd \fB\-T \-G\fPpixel.grd
.SH SEE ALSO
gmt, grdfft, grdfilter
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
