.TH GRDTRACK l "1 August 1995"
.SH NAME
grdtrack \- Sampling of a 2-D grdfile along 1-D trackline
.SH SYNOPSIS
\fBgrdtrack\fP \fIxyfile\fP \fB\-G\fP\fIgrdfile\fP [ \fB\-H\fP ] [ \fB\-L\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-Q\fP ] [ \fB\-V\fP ] [ \fB\-:\fP ]
.SH DESCRIPTION
\fBgrdtrack\fP reads a 2-D binary grdfile and an ASCII table (from file or standard input)
with (x,y) positions in the first two columns (more columns may be present). It then samples the
gridded data set at the positions in
the ASCII file and outputs the ASCII file with the sampled values added as a new column. 
A bicubic [Default] or bilinear interpolation is used to sample the grid.  Free
boundary conditions are assumed (curvature and 3rd normal derivative is zero).
.TP
\fIxyfile\fP
This is an ASCII file where the first 2 columns hold the (x,y) positions where the user wants to sample
the 2-D data set.
.TP
.B \-G
\fIgrdfile\fP is a 2-D binary grd file with the function f(x,y).
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-L
Indicates that the x column contains longitudes, which may differ from the region
specified in \fIgrdfile\fP by [multiples of] 360 degrees [Default assumes no periodicity].
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fI<flag>\fP.
[Default is '>'].
.TP
.B \-Q
Quick mode.  Use bilinear rather than bicubic interpolation.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.SH EXAMPLES
To sample the file hawaii_topo.grd along the SEASAT track track_4.xyg (An ASCII
table containing longitude, latitude, and SEASAT-derived gravity, preceeded by one header record), try
.br
.sp
grdtrack track_4.xyg \fB\-G\fPhawaii_topo.grd \fB\-H\fP > track_4.xygt
.SH BUGS
All the peripheral nodes needed to evaluate the interpolation must be real in order to
return a sampled value.  If any of these are NaN then NaN is returned.
.SH SEE ALSO
gmt, surface, sample1d
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
