.TH GRDTREND l "1 August 1995"
.SH NAME
grdtrend \- Fit and/or remove a polynomial trend in a grd file
.SH SYNOPSIS
\fBgrdtrend\fP \fIgrdfile\fP \fB\-N\fP\fIn_model\fP[\fBr\fP] 
[ \fB\-D\fP\fIdiff.grd\fP ] [ \fB\-T\fP\fItrend.grd\fP ] [ \fB\-V\fP ] 
[ \fB\-W\fP\fIweight.grd\fP ]
.SH DESCRIPTION
\fBgrdtrend\fP reads a 2-D gridded file and fits a low-order polynomial
trend to these data by [optionally weighted] least-squares.  The trend surface is 
defined by:
.sp
m1 + m2*x + m3*y + m4*x*y + m5*x*x + m6*y*y + m7*x*x*x + m8*x*x*y + m9*x*y*y + m10*y*y*y.
.sp
The user must specify \fB\-N\fP\fIn_model\fP, the number of model parameters to use; 
thus, \fB\-N\fP\fI4\fP fits a bilinear trend, \fB\-N\fP\fI6\fP a quadratic surface, 
and so on.  Optionally, append \fBr\fP to the \fB\-N\fP option to perform a 
robust fit.  In this case, the program will iteratively reweight the data based on 
a robust scale estimate, in order to converge to a solution insensitive to outliers.  
This may be handy when separating a "regional" field from a "residual" which should 
have non-zero mean, such as a local mountain on a regional surface.
.sp
If data file has values set to NaN, these will be ignored during fitting; if output 
files are written, these will also have NaN in the same locations.
.sp
No space between the option flag and the associated arguments.
.TP
\fIgrdfile\fP
The name of a 2-D binary grd file.
.TP
.B \-N
\fIn_model\fP[\fBr\fP] sets the number of model parameters to fit.  Append \fBr\fP for robust fit.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-D
Write the difference (input data - trend) to the file \fIdiff.grd\fP.
.TP
.B \-T
Write the fitted trend to the file \fItrend.grd\fP.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
If \fIweight.grd\fP exists, it will be read and used to solve a weighted 
least-squares problem.  [Default:  Ordinary least-squares fit.]  If the robust 
option has been selected, the weights used in the robust fit will be written to 
\fIweight.grd\fP.
.SH REMARKS
The domain of x and y will be shifted and scaled to [-1, 1] and the basis functions are built from 
Legendre polynomials.  These have a numerical advantage in the form of the matrix which must be 
inverted and allow more accurate solutions.  NOTE: The model parameters listed with \fB\-V\fP are 
Legendre polynomial coefficients; they are not numerically equivalent to the m#s in the equation 
described above.  The description above is to allow the user to match \fB\-N\fP with the order of the 
polynomial surface.    
.SH EXAMPLES
To remove a planar trend from hawaii_topo.grd and write result in hawaii_residual.grd, try
.br
.sp
\fBgrdtrend\fP hawaii_topo.grd \fB\-N\fP3 \fB\-D\fPhawaii_residual.grd
.br
.sp
To do a robust fit of a bicubic surface to hawaii_topo.grd, writing the result in 
hawaii_trend.grd and the weights used in hawaii_weight.grd, and reporting the progress, try
.br
.sp
\fBgrdtrend\fP hawaii_topo.grd \fB\-N\fP10\fBr\fP \fB\-T\fPhawaii_trend.grd 
\fB\-W\fPhawaii_weight.grd \fB\-V\fP
.SH SEE ALSO
gmt, grdfft, grdfilter
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
