.TH GRDVIEW l "1 August 1995"
.SH NAME
grdview \- Create 3-D perspective grayshaded/colored image or mesh from a 2-D grd file
.SH SYNOPSIS
\fBgrdview\fP \fIrelief_file\fP \fB\-J\fP\fIparameters\fP 
[ \fB\-B\fP\fItickinfo\fP ] [\fB\-C\fP\fIcptfile\fP] [ \fB\-D\fP\fIndec\fP ] [ \fB\-E\fP\fIview_az/view_el\fP ] 
[ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-G\fP\fIdrapefile\fP] [ \fB\-I\fP\fIintensfile\fP] [ \fB\-K\fP ] 
[ \fB\-M\fP\fImeshpen\fP] [ \fB\-N\fP\fIlevel\fP[/\fIr/g/b\fP]] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-Q\fP\fItype\fP ] [ \fB\-R\fP\fIwest/east/south/north/zmin/zmax\fP[\fIr\fP] ] [ \fB\-S\fP\fIsmooth\fP ] 
[ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-W\fP\fIcontourpen\fP ] [ \fB\-X\fP\fIx-shift\fP ] 
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBgrdview\fP reads a 2-D gridded file and produces a 3-D perspective plot by 
drawing a mesh, painting a colored/grayshaded surface made up of polygons, or by scanline conversion of these polygons
to a rasterimage.  Options include draping a data set on top of a surface, plotting of contours on top of the
surface, and apply artificial illumination based on intensities provided in a separate grd file.
.TP
\fIrelief_file\fP
2-D gridded data set to be imaged (the relief of the surface).
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-C
name of the color palette file.  Must be present if you want (1) mesh plot with
contours (\fB\-Qm\fP), or (2) shaded/colored perspective image (\fB\-Qs\fP or \fB\-Qi\fP).
.TP
.B \-D
Sets number of decimals used to specify color/gray in PostScript output. Makes smaller output file
at the expense of less color resolution.  E.g., 3 gives 1000, 2 gives 100, and 1 gives 10 choices each
or r, g, and b, values [3].
.TP
.B \-E
Sets the view point by specifying azimuth and elevation in degrees. [Default is 180/90]
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is black]
.TP
.B \-G
Drape the image in \fIdrapefile\fP on top of the relief provided by \fIrelief_file\fP. [Default is \fIrelief_file\fP].
Note that \fB\-Jz\fP and \fB\-N\fP always refers to the \fIrelief_file\fP.  The \fIdrapefile\fP only provides
the information pertaining to colors.
.TP
.B \-I
Gives the name of a grdfile with intensities in the (-1,+1) range. [Default is no illumination].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Sets the pen attributes used for the mesh. [Default: width = 1, color = 0/0/0, texture = solid] 
.TP
.B \-N
Draws a plane at this z-level.  If the optional r/g/b is provided, the frontal facade between
the plane and the data perimeter is colored.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
This option may be used to indicate the range used for the 3-D axes [Default is
region given by the \fIrelief_file\fP].  You may ask for a larger
\fIw/e/s/n\fP region to have more room between the image and the axes.  A smaller region
than specified in the \fIrelief_file\fP will result in a subset of the grid.
.TP
.B \-Q
Select one of three settings: 1. Specify \fBm\fP for mesh plot [Default], and optionally append /r/g/b for a different mesh paint [white].
2. Specify \fBs\fP for surface plot, and optionally append \fBm\fP to have mesh lines drawn on top of surface.
3. Specify \fBi\fP for image plot, and optionally append the effective dpi resolution for the rasterization [100].
This option will apply a simple clippath to avoid overwriting the background (since the resulting image is rectangular).
Depending on the projection this may backfire; if so turn clipping off by using upper case \fBI\fP.
For any of these choices, you may force a monochrome image by appending \fBg\fP.  Colors are then
converted to shades of gray using the (television) YIQ transformation.
.TP
.B \-S
Smooth the contours before plotting (see \fBgrdcontour\fP) [Default is no smoothing]
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Draw contour lines on top of surface or mesh (not image).  Append pen attributes used for the contours.
[Default: width = 3, color = 0/0/0, texture = solid].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-Z
Sets the z-level of the basemap [0].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To make a mesh plot from the file hawaii_grav.grd and drawing the contours
given in the color palette file hawaii.cpt on a Lambert map
at 0.5 inch/degree along the standard parallels 18 and 24, with vertical scale 50 mgal/inch, and
looking at the surface from SW at 30 degree elevation, try 
.br
.sp
grdview hawaii_grav.grd \fB\-Jl\fP18/24/0.5 \fB\-C\fPhawaii.cpt \fB\-Jz\fPLEN_3 \fB\-Q\fPm \fB\-N\fP-100 \fB\-E\fP225/30 \fB\-W\fP > hawaii_grav_image.ps
.br
.sp
To create a illuminated color perspective plot of the gridded data set image.grd, using the color
palette file color.rgb, with linear scaling at 10 inch/x-unit
and tickmarks every 5 units, with intensities provided by the file intens.grd, and looking from the SE, try
.br
.sp
grdview image.grd \fB\-Jx\fP10.0 \fB\-C\fPcolor.rgb \fB\-Q\fPs \fB\-E\fP135/30 \fB\-I\fPintens.grd  > image3D.ps
.br
.sp
To make the same plot using the rastering option with dpi = 50, try
.br
.sp
grdview image.grd \fB\-Jx\fP10.0 \fB\-C\fPcolor.rgb \fB\-Q\fPi50 \fB\-E\fP135/30 \fB\-I\fPintens.grd  > image3D.ps
.br
.sp
To create a color \fIPostScript\fP perspective plot of the gridded data set magnetics.grd, using the color
palette file mag_intens.cpt, draped over the relief given by the file topography.grd, with Mercator scaling at 1 inch/degree
and tickmarks every 1 degree, with intensities provided by the file topo_intens.grd, and looking from the SE, try
.br
.sp
grdview topography.grd \fB\-Jm\fP1 \fB\-G\fPmagnetics.grd \fB\-C\fPmag_intens.cpt \fB\-Q\fPs \fB\-E\fP140/30 \fB\-I\fPtopo_intens.grd  > draped3D.ps
.SH BUGS
For the \fB\-Q\fPs option:  \fIPostScript\fP provides no way of smoothly varying colors within a polygon, so colors can only
vary from polygon to polygon.  To obtain smooth images this way you may resample the grdfile(s) using \fBgrdsample\fP or
use a finer grid size when running gridding programs like \fBsurface\fP or \fBnearneighbor\fP.  Unfortunately,
this produces huge \fIPostScript\fP files.  The alternative is to use the \fB\-Q\fPi option, which
computes quasi-bilinear continuous color variations within polygons by using scanline conversion to image the polygons.  However,
when using \fB\-Q\fPi, the \fB\-B\fP option is deactivated; plot axes separately as a psbasemap overlay.
.br
.sp
Header must be plotted separately using \fBpstext\fP.
.SH SEE ALSO
gmt, grdcontour, grdimage, nearneighbor, psbasemap, pscontour, pstext, surface
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
