.TH MINMAX l "1 August 1995"
.SH NAME
minmax \- Find extreme values in ASCII tables
.SH SYNOPSIS
\fBminmax\fP [ \fIasciifiles\fP] [ \fB\-H\fP ] [ \fB\-I\fP\fIdx\fP[/\fIdy\fP] ] [ \fB\-:\fP ]
.SH DESCRIPTION
\fBminmax\fP reads its standard input [or from asciifiles] and finds the
extreme values in each of the columns.  It recognizes NaNs and
will print warnings if the number of columns vary from record to record.
As an option, \fBminmax\fP will find the extent of the first two columns rounded
up and down to the nearest multiple of dx/dy.  This output will be in the form
\fB\-R\fP\fIw/e/s/n\fP which can be used directly in the command line for other programs.
.TP
\fIxyzfile\fP
ASCII file holding a fixed number of data columns. 
.SH OPTIONS
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Report the min/max of the first two columns to the nearest multiple of dx and dy,
and output this in the form -Rw/e/s/n.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
Only works when \fB\-I\fP is selected.
.SH EXAMPLES
To find the extreme values in the file ship_gravity.xygd, try
.br
.sp
minmax ship_gravity.xygd
.br
.sp
Output should look like
.br
.sp
ship_gravity.xygd: N = 6992 <326.125/334.684> <-28.0711/-8.6837> <-47.7/177.6> <0.6/3544.9>
.br
.sp
To find the extreme values in the file track.xy to the nearest 5 units and use this
region to draw a line using psxy, try
.br
.sp
psxy `minmax \fB\-I\fP5 track.xy` track.xy \fB\-Jx\fP1 \fB\-B\fP5 \fB\-P\fP > track.ps
.SH SEE ALSO
gmt
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
