.TH NEARNEIGHBOR l "1 August 1995"
.SH NAME
nearneighbor \- A "Nearest neighbor" gridding algorithm
.SH SYNOPSIS
\fBnearneighbor\fP [ \fIxyzfile(s)\fP ] \fB\-G\fP\fIout_grdfile\fP \fB\-I\fP\fIx_inc\fP[m|c][/\fIy_inc\fP[m|c]]  
\fB\-N\fP\fIsectors\fP \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] \fB\-S\fP\fIsearch_radius\fP[m|c] 
[ \fB\-E\fP\fIempty\fP ] [ \fB\-F\fP ] [ \fB\-H\fP ] [ \fB\-M\fP ] [ \fB\-V\fP ] [ \fB\-W\fP ] [ \fB\-:\fP ] [ \fB\-b\fP[\fBd\fP] ]
.SH DESCRIPTION
\fBnearneighbor\fP reads arbitrarily located (x,y,z[, w]) triples [quadruplets]
from standard input [or \fIxyzfile(s)\fP] and uses a nearest neighbor algorithm to assign 
an average value to each node that have one or more points within a radius centered on the node.
The average value is computed as a weighted mean of all points inside the search radius.  The
weighting function used is w(r) = 1.0 / (1 + d * d), where d = 3 * r / search_radius and r is
distance from the node.  This weight is modulated by the observation points' weights [if supplied].
.TP
\fIxyzfile(s)\fP
3 [or 4, see \fB\-W\fP] column ASCII file(s) [or binary, see \fB\-b\fP] holding (x,y,z[,w]) data values.  If no file is specified, \fBnearneighbor\fP
will read from standard input.
.TP
.B \-G
Give the name of the output grdfile.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the block size. Append m to indicate minutes, c to indicate seconds.
.TP
.B \-N
The circular area centered on each node is divided into several sectors.  Average values
will only be computed if there is at least one value inside each of the sectors for a
given node.  Nodes that fail this test are assigned the value NaN (but see \fB\-E\fP).  [Default is quadrant
search, i.e., \fIsectors\fP = 4].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-S
Sets the \fIsearch_radius\fP.  In same units as the grid spacing (but see \fB\-M\fP).  Append m to indicate minutes, c to indicate seconds.
.SH OPTIONS
.TP
.B \-E
Set the value assigned to empty nodes [NaN].
.TP
.B \-F
Force pixel registration.  [Default is grid registration].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
Not used with binary data.
.TP
.B \-M
Use map units, i.e., input data and grid spacings are in degrees of longitude and latitude,
and \fIsearch_radius\fP is in km.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-W
Input data have a 4th column containing observation point weights.  These are multiplied
with the geometrical weight factor to determine the actual weights used in the calculations.
.TP
.B \-b
Selects binary input mode  [Default is ASCII].
Append \fBd\fP to indicate double precision for binary data [Default is single].
.SH EXAMPLES
.sp
To create a gridded data set from the file seaMARCII_bathy.lon_lat_z using a 0.5 min grid,
a 5 km search radius, using an octant search, and set empty nodes to -9999, try
.sp
nearneighbor seaMARCII_bathy.lon_lat_z \fB\-R\fP242/244/-22/-20 \fB\-I\fP.5m \fB\-E\fP-9999 \fB\-G\fPbathymetry.grd
\fB\-S\fP5 \fB\-N\fP8
.SH SEE ALSO
blockmean, blockmedian, gmt, surface, triangulate
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
