.TH PSBASEMAP l "1 August 1995"
.SH NAME
psbasemap \- To plot \fIPostScript\fP basemaps
.SH SYNOPSIS
\fBpsbasemap\fP \fB\-B\fP\fItickinfo\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] 
[ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-G\fP\fIfill\fP ] [ \fB\-K\fP ] 
[ \fB\-L\fP[f][x]\fIlon0/lat0/slat/length\fP[m] ] [ \fB\-O\fP ] 
[ \fB\-P\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-X\fP\fIy-level\fP ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBpsbasemap\fP creates PostScript code that will produce a basemap.  Several map projections
are available, and the user may specify separate tickmark intervals for boundary annotation,
ticking, and [optionally] gridlines.  A simple map scale may also be plotted.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
.B \-B
Sets map boundary tickmark intervals. \fItickinfo\fP is a textstring made up of one or more
concatenated substrings of the form [\fBwhich\fP]\fItick\fP[\fBm|c\fP].  The optional \fBwhich\fP
can be either \fBa\fP for annotation interval [Default], \fBf\fP for frame tick interval, or
\fBg\fP for gridline interval.  If frame interval is not set, it is assumed to be the same
as annotation interval. \fItick\fP is the desired tick interval.  The optional \fBm|c\fP indicates
minutes (\fBm\fP) or seconds (\fBc\fP).  To specify separate x and y ticks, separate the substrings that apply to the x and y
axes with a slash [/] (If a 3-D basemap is selected with \fB\-E, \-Jz\fP, a third substring pertaining
to the vertical axis may be appended.)  For linear/log/power projections (\fB\-Jx\fP): Labels
for each axis can be added by surrounding them with colons.  If the first character in the
label is a period, then the label is used as plot title.  If the label consists of more than one
word, enclose the entire label in double quotes (e.g., :"my label":).
.br
By default, all 4 boundaries are plotted (referred to as \fBW, E, S, N\fP).  To change the default,
append the code for those you want (e.g., \fBWS\fP for standard lower-left x- and y-axis system).
Upper case (e.g., \fBW\fP) means draw axis/tickmarks AND annotate it, whereas lower case
(e.g., \fBw\fP) will only draw axis/tickmarks.  Note that this convention means that you cannot
use the exponential notation for tick-intervals as a conflict with \fBwesn\fP will occur.
(If a 3-D basemap is selected with \fB\-E\fP and \fB\-Jz\fP, append \fBZ\fP or \fBz\fP to control the appearance
of the vertical axis.  Append '+' to draw the outline of the cube defined by \fB\-R\fP)
.br
For non-geographical projections:
Give negative scale (in \fB\-Jx\fP) or axis length (in \fB\-JX\fP) to change the direction
of increasing coordinates (i.e., to make the y-axis positive down).  For log10 axes:  Annotations
can be specified in one of three ways:  (1) \fItick\fP can be 1, 2, or 3.  Annotations will then
occur at 1, 1\-2\-5, or 1\-2\-3\-4\-...\-9, respectively.  This option can also be used for
the frame and grid intervals.  (2) An \fBl\fP is appended to the \fItickinfo\fP string.
Then, log10 of the tick value is plotted at every integer log10 value.  (3) A \fBp\fP is appended
to the \fItickinfo\fP string.  Then, annotations appear as 10 raised to log10 of the tick value.
For power axes: Annotations can be specified in one of two ways:  (1) \fItick\fP sets the
regular annotation interval.  (2) A \fBp\fP is appended to the \fItickinfo\fP string.  Then,
the annotation interval is expected to be in transformed units, but the annotation value
will be plotted as untransformed units.  E.g., if \fItick\fP = 1 and \fIpower\fP = 0.5 (i.e., sqrt),
then equidistant annotations labeled 1\-4\-9... will appear.
.TP
.B \-J
Selects the map projection.  The following character determines the projection.  If the
character is upper case then the argument(s) supplied as scale(s) is interpreted to be
the map width (or axis lengths) in
inch, else the scale argument(s) is the map scale (see its definition for each projection).
Choose one of the following projections (The \fBE\fP or \fBC\fP after projection names stands for
Equal-Area and Conformal, respectively):
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP or \fB\-JC\fP\fIlon0/lat0/width\fP (Cassini)
.br
	Give projection center and scale (1:xxxx or inch/degree).
.br
\fB\-Jm\fP\fIscale\fP or \fB\-JM\fP\fIwidth\fP (Mercator \fB[C]\fP)
.br
	Give scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jo\fP\fIparameters\fP (Oblique Mercator \fB[C]\fP).  Specify one of:
.br
	\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP or \fB\-JOa\fP\fIlon0/lat0/azimuth/width\fP
.br
		Set projection center, azimuth of oblique equator, and scale.
.br
	\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP or \fB\-JOb\fP\fIlon0/lat0/lon1/lat1/scale\fP
.br
		Set projection center, another point on the oblique equator, and scale.
.br
	\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP or \fB\-JOc\fP\fIlon0/lat0/lonp/latp/scale\fP
.br
		Set projection center, pole of oblique projection, and scale.
.br
	Give scale along oblique equator (1:xxxx or inch/degree).
.br
\fB\-Jq\fP\fIlon0/scale\fP or \fB\-JQ\fP\fIlon0/width\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
	Give the central meridian and scale (1:xxxx or inch/degree).
.br
\fB\-Jt\fP\fIlon0/scale\fP or \fB\-JT\fP\fIlon0/width\fP (TM - Transverse Mercator \fB[C]\fP)
.br
	Give the central meridian and scale (1:xxxx or inch/degree).
.br
\fB\-Ju\fP\fIzone/scale\fP or \fB\-JU\fP\fIzone/width\fP (UTM - Universal Transverse Mercator \fB[C]\fP)
.br
	Give the zone number and scale (1:xxxx or inch/degree).
.br
	Use negative zone numbers for the southern hemisphere.
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP or \fB\-JY\fP\fIlon0/lats/width\fP (Basic Cylindrical Projections \fB[E]\fP)
.br
	Give the central meridian, standard parallel, and scale (1:xxxx or inch/degree).
.br
	The standard parallel is typically one of these (but can be any value):
.br
	45	- The Peters projection
.br
	37.4	- The Trystan Edwards projection
.br
	30	- The Behrman projection
.br
	0	- The Lambert projection
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP or \fB\-JA\fP\fIlon0/lat0/width\fP (Lambert \fB[E]\fP).
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP or \fB\-JE\fP\fIlon0/lat0/width\fP (Equidistant).
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP or \fB\-JG\fP\fIlon0/lat0/width\fP (Orthographic).
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP or \fB\-JS\fP\fIlon0/lat0/width\fP (General Stereographic \fB[C]\fP)
.br
	\fIlon0/lat0\fP specifies the projection center.
.br
	Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
.br
	in inch from origin to the oblique latitude \fIlat\fP.
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JB\fP\fIlon0/lat0/lat1/lat2/width\fP (Albers \fB[E]\fP)
.br
	Give projection center, two standard parallels, and scale (1:xxxx or inch/degree).
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JL\fP\fIlon0/lat0/lat1/lat2/width\fP (Lambert \fB[C]\fP)
.br
	Give origin, 2 standard parallels, and scale along these (1:xxxx or inch/degree).
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP or \fB\-JH\fP\fIlon0/width\fP (Hammer \fB[E]\fP)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Ji\fP\fIlon0/scale\fP or \fB\-JI\fP\fIlon0/width\fP (Sinusoidal \fB[E]\fP)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jk\fP\fIlon0/scale\fP or \fB\-JK\fP\fIlon0/width\fP (Eckert VI \fB[E]\fP)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jn\fP\fIlon0/scale\fP or \fB\-JN\fP\fIlon0/width\fP (Robinson)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jr\fP\fIlon0/scale\fP \fB\-JR\fP\fIlon0/width\fP (Winkel Tripel)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
\fB\-Jw\fP\fIlon0/scale\fP or \fB\-JW\fP\fIlon0/width\fP (Mollweide \fB[E]\fP)
.br
	Give the central meridian and scale along equator (1:xxxx or inch/degree).
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP or \fB\-JP\fP\fIwidth\fP (Linear projection for polar (theta,r) coordinates)
.br
	Give scale in inch/r-unit.
.br
\fB\-Jx\fP\fIx-scale\fP[\fI/y-scale\fP] or \fB\-JX\fP\fIwidth\fP[\fI/height\fP]
.br
\fIscale\fP [or \fIwidth\fP] can be any of the following 3 types:
.br
	\fB\-Jx\fP\fIscale\fP		- Regular linear scaling.
.br
	\fB\-Jx\fP\fIscale\fP\fBl\fP	- Take log10 of values before scaling.
.br
	\fB\-Jx\fP\fIscale\fP\fBp\fP\fIpower\fP	- Raise values to \fIpower\fP before scaling.
.br
Give \fIx-scale\fP in inch/x-unit and \fIy-scale\fP in inch/y-unit.
(\fIy-scale\fP = \fIx-scale\fP if not specified separately).  Use negative
scale(s) to reverse the direction of an axis (e.g., to have y be positive down).
.br
.sp
Append 'd' if x and y are geographical coordinates in degrees.
Default axes lengths (see gmtdefaults) can be invoked
using \fB\-JXh\fP (for landscape); \fB\-JXv\fP (for portrait) will swap the x- and y-axes lengths.
The \fBGMT\fP default unit for this installation is inch.  However, you may
change this by editing your .gmtdefaults file(s) (run gmtdefaults to create one
if you don't have it).
.br
	The ellipsoid used in the map projections is user-definable by editing the .gmtdefaults file
in your home directory.  12 commonly used ellipsoids and a spheroid are currently
supported, and users may also specify their own ellipsoid parameters (see man gmtdefaults for more details).
\fBGMT\fP default is WGS-84.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.TP
.B \-E
Sets the viewpoint's azimuth and elevation (for perspective view) [180/90]
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is 0/0/0 (black)]
.TP
.B \-G
Sets a color or pattern with which to paint inside of basemap. [Default is no fill]
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Draws a simple map scale centered on \fIlon0/lat0\fP.  Use \fB\-Lx\fP to specify position in inch instead.
Scale is calculated at latitude \fIslat\fP, \fIlength\fP is in km [miles if m is appended].
Use \fB\-Lf\fP to get a "fancy" scale [Default is plain].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the basemap [0].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
The following section illustrates the use of the options by giving some examples for the
available map projections.  Note how scales may be given in several different ways
depending on the projection.  Also note the use of upper case letters to specify map width in inch
instead of map scale.
.sp
.SH NON-GEOGRAPHICAL PROJECTIONS
.SH Linear x-y plot
To make a linear x/y frame with all axes, but with only left and bottom axes annotated, using xscale = yscale = 1.0,
ticking every 1 unit and annotating every 2, and using xlabel = "Distance" and ylabel = "No of samples", try
.br
.sp
psbasemap \fB\-R\fP0/9/0/5 \fB\-Jx\fP1 \fB\-Bf\fP1\fBa\fP2:Distance:/:"No of samples":\fBWeSn\fP > linear.ps
.SH log-log plot
To make a log-log frame with only the left and bottom axes, where the x-axis is 9 inch and annotated
every 1-2-5 and the y-axis is 6 inch and anotated every power of 10 but has tickmarks every 0.1, try
.br
.sp
psbasemap \fB\-R\fP1/10000/1e20/1e25 \fB\-JX\fP9\fBl\fP/6\fBl\fP \fB\-B\fP2:Wavelength:/a1\fBpf\fP3:Power:\fBWS\fP > loglog.ps
.SH power axes
To design an axis system to be used for a depth\-sqrt(age) plot with depth positive down, ticked and
annotated every 500m, and ages annotated at 1 my, 4 my, 9 my etc, try
.br
.sp
psbasemap \fB\-R\fP0/100/0/5000 \fB\-Jx\fP1\fBp\fP0.5/-0.001 \fB\-B\fP1\fBp\fP:"Crustal age":/500:Depth: > power.ps
.SH Polar (theta,r) plot
For a base map for use with polar coordinates, where the radius from 0 to 1000 should correspond
to 3 inch, and with gridlines and ticks every 30 degrees and 100 units, try
.br
.sp
psbasemap \fB\-R\fP0/360/0/1000 \fB\-JP\fP6 \fB\-B\fP30\fBp\fP/100 > polar.ps
.br
.sp
.SH CYLINDRICAL MAP PROJECTIONS
.SH Cassini
A 4-inch-wide basemap using the Cassini projection may be obtained by
.br
.sp
psbasemap \fB\-R\fP20/50/20/35 \fB\-JC\fP35/28/4 \fB\-P \-B\fP5\fBg\fP5:.Cassini: > cassini.ps
.SH Mercator [conformal]
A Mercator map with scale 0.025 inch/degree along equator, and showing the length of 5000 km along the equator (centered on 1/1 inch), may be plotted as
.br
.sp
psbasemap \fB\-R\fP90/180/-50/50 \fB\-Jm\fP0.025 \fB\-B\fP30\fBg\fP30:.Mercator: \fB\-Lx\fP1/1/0/5000 > mercator.ps
.SH Oblique Mercator [conformal]
To create a page-size global oblique Mercator basemap for a pole at (90,30) with gridlines every 30 degrees, try
.br
.sp
psbasemap  \fB\-R\fP0/360/-70/70 \fB\-Joc\fP0/0/90/30/0.025d \fB\-B\fP30\fBg\fP30:."Oblique Mercator": > oblmerc.ps
.SH Transverse Mercator [conformal]
A regular Transverse Mercator basemap for some region may look like
.br
.sp
psbasemap \fB\-R\fP69:30/71:45/-17/-15:15 \fB\-Jt\fP70/1:1000000 \fB\-B\fP15\fBm\fP:."Survey area": \fB\-P\fP > transmerc.ps
.SH Equidistant Cylindrical Projection
This projection only needs the central meridian and scale.  A 9 inch wide global basemap centered on the 130E
meridian is made by
.br
.sp
psbasemap \fB\-R\fP-50/310/-90/90 \fB\-JQ\fP130/9 \fB\-B\fP30\fBg\fP30:."Equidistant Cylindrical": > cyl_eqdist.ps
.br
.sp
.SH Universal Transverse Mercator [conformal]
To use this projection you must know the UTM zone number, which defines the central meridian.  A UTM
basemap for Indo-China can be plotted as
.br
.sp
psbasemap \fB\-R\fP95/5/108/20\fBr \-Ju\fP46/1:10000000 \fB\-B\fP3\fBg\fP3:.UTM: > utm.ps
.SH Basic Cylindrical [equal-area]
First select which of the cylindrical equal-area projections you want by deciding on the standard parallel.
Here we will use 45 degrees which gives the Peters projection.  A 9 inch wide global basemap centered on the Pacific
is made by
.br
.sp
psbasemap \fB\-R\fP0/360/-90/90 \fB\-JY\fP180/45/9 \fB\-B\fP30\fBg\fP30:.Peters: > peters.ps
.br
.sp
.SH CONIC MAP PROJECTIONS
.SH Albers [equal-area]
A basemap for middle Europe may be created by
.br
.sp
psbasemap \fB\-R\fP0/90/25/55 \fB\-Jb\fP45/20/32/45/0.1 \fB\-B\fP10\fBg\fP10:."Albers Equal-area": > albers.ps
.SH Lambert [conformal]
Another basemap for middle Europe may be created by
.br
.sp
psbasemap \fB\-R\fP0/90/25/55 \fB\-Jl\fP45/25/32/45/0.1 \fB\-B\fP10\fBg\fP10:."Lambert Conformal Conic": > lambertc.ps
.br
.sp
.SH AZIMUTHAL MAP PROJECTIONS
.SH Lambert [equal-area]
A 6-inch-wide global view of the world from the vantage point -80/-30 will give the following basemap:
.br
.sp
psbasemap \fB\-R\fP0/360-/-90/90 \fB\-JA\fP-80/-30/6 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:."Lambert Azimuthal": > lamberta.ps
.br
.sp
Follow the instructions for stereographic projection if you want to impose rectangular
boundaries on the azimuthal equal-area map but substitute \fB\-Ja\fP for \fB\-Js\fP.
.SH Equidistant
A 6-inch-wide global map in which distances from the center (here 125/10) to any point is true can be obtained by:
.br
.sp
psbasemap \fB\-R\fP0/360-/-90/90 \fB\-JE\fP125/10/6 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:."Equidistant": > equi.ps
.br
.SH Orthographic
A global perspective (from infinite distance) view of the world from the vantage point -100/40 will give the following 6-inch-wide basemap:
.br
.sp
psbasemap \fB\-R\fP0/360-/-90/90 \fB\-JG\fP125/10/6 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:."Orthographic": > ortho.ps
.br
.SH Stereographic [conformal]
To make a Polar stereographic projection basemap with radius = 5 inch to \-60 degree latitude, with plot title
"Salinity measurements", using 5 degrees annotation/tick interval and 1 degree gridlines, try
.br
.sp
psbasemap \fB\-R\fP-45/45/-90/-60 \fB\-Js\fP0/-90/5/-60 \fB\-B\fP5\fBg\fP1:."Salinity measurements": > stereo1.ps
.br
.sp
To make a 5-inch-wide stereographic basemap for Australia from an arbitrary view point (not the poles), and use a
rectangular boundary, we must give the pole for the new projection and use the \fB\-R\fP option to
indicate the lower left and upper right corners (in lon/lat) that will define our rectangle.  We
choose a pole at 130/-30 and use 100/-45 and 160/-5 as our corners.  The command becomes
.br
.sp
psbasemap \fB\-R\fP100/-45/160/-5\fBr \-JS\fP130/-30/5 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:."General Stereographic View": > stereo2.ps
.br
.sp
.SH MISCELLANEOUS MAP PROJECTIONS
.SH Hammer [equal-aera]
The Hammer projection is mostly used for global maps and thus the spherical form is used.
To get a world map centered on Greenwich at a scale of 1:200000000, try
.br
.sp
psbasemap \fB\-R\fP0/360/-90/90 \fB\-Jh\fP180/1:200000000 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:.Hammer: > hammer.ps
.SH Sinusoidal [equal-aera]
To make a sinusiodal world map centered on Greenwich, with a scale along the equator of 0.02 inch/degree, try
.br
.sp
psbasemap \fB\-R\fP0/360/-90/90 \fB\-Ji\fP0/0.02 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:."Sinusoidal": > sinus1.ps
.br
.sp
To make an interrupted sinusiodal world map with breaks at 160W, 20W, and 60E, with a scale along the equator of 0.02 inch/degree, try the following sequence of commands:
.br
.sp
psbasemap \fB\-R\fP-160/-20/-90/90 \fB\-Ji\fP-90/0.02 \fB\-B\fP30\fBg\fP30/15\fBg\fP15\fBWesn\fP \fB\-K\fP > sinus_i.ps
.br
psbasemap \fB\-R\fP-20/60/-90/90 \fB\-Ji\fP20/0.02 \fB\-B\fP30\fBg\fP30/15\fBg\fP15\fBwesn\fP \fB\-O \-K \-X\fP2.8 >> sinus_i.ps
.br
psbasemap \fB\-R\fP60/200/-90/90 \fB\-Ji\fP130/0.02 \fB\-B\fP30\fBg\fP30/15\fBg\fP15\fBwEsn\fP \fB\-O \-X\fP1.6 >> sinus_i.ps
.br
.SH Eckert VI [equal-aera]
Another pseudo-cylindrical projection typically used for global maps only.  Set the central longitude and scale, e.g.,
.br
.sp
psbasemap \fB\-R\fP0/360/-90/90 \fB\-Jk\fP180/0.025 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:."Eckert VI": > eckert4.ps
.SH Robinson
Projection designed to make global maps "look right".  Set the central longitude and width, e.g.,
.br
.sp
psbasemap \fB\-R\fP-180/180/-90/90 \fB\-JN\fP0/8 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:."Robinson": > robinson.ps
.SH Winkel Tripel
Yet another projection typically used for global maps only.  You can set the central longitude, e.g.,
.br
.sp
psbasemap \fB\-R\fP90/450/-90/90 \fB\-JR\fP270/9 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:."Winkel Tripel": > winkel.ps
.SH Mollweide [equal-aera]
The Mollweide projection is also mostly used for global maps and thus the spherical form is used.
To get a 10-inch-wide world map centered on the Dateline, try
.br
.sp
psbasemap \fB\-R\fP0/360/-90/90 \fB\-JW\fP180/10 \fB\-B\fP30\fBg\fP30/15\fBg\fP15:.Mollweide: > mollweide.ps
.SH RESTRICTIONS
For some projections, a spherical earth is implicitly assumed.  A warning will notify the user if \fB\-V\fP
is set.
.SH BUGS
The \fB\-B\fP option is somewhat complicated to explain and comprehend.  However, it is fairly simple for
most applications (see examples).
.SH SEE ALSO
gmtdefaults, gmt
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
