.TH PSCLIP l "1 August 1995"
.SH NAME
psclip \- To set up polygonal clip paths
.SH SYNOPSIS
\fBpsclip\fP \fIxyfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] 
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-E\fP\fIaz/el\fP ] [ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-K\fP ] [ \fB\-N\fP ] 
[ \fB\-M\fP[\fIflag\fP] ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-S\fP ] 
[ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] 
[ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-c\fP\fIcopies\fP ]  [ \fB\-:\fP ] 
.SH DESCRIPTION
\fBpsclip\fP reads (x,y) file(s) [or standard input] and draws polygons that are
activated as clipping paths.  Several files may be read to create complex paths
consisting of several non-connecting segments.  As an option (\fB\-N\fP), the user
may choose to reverse the sense of what is the inside and outside of the paths.
After subsequent plotting, which will be clipped against these paths, the clipping
may be deactivated by running psclip with the \fB\-S\fP option only.
.TP
\fIxyfiles\fP
File(s) with (x,y) values for clip polygons.  If no files are given, the
standard input is read.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments
.sp
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation [180/90]
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is black]
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fI<flag>\fP.
[Default is '>'].
.TP
.B \-N
Invert the sense of what is inside and outside, i.e., use the outside of the polygons for clipping.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Mark end of existing clip path.  No input file is needed.  Implicitly sets \fB\-O\fP.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the polygons [0].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To make an overlay \fIPostScript\fP file that will set up a complex clip area to which
subsequent plotting will be confined to, try:
.br
.sp
psclip my_region.xy \fB\-R\fP0/40/0/40 \fB\-J\fPm0.3 \fB\-O \-K\fP > clip_mask_on.ps
.br
.sp
To deactivate the clipping, run:
.br
.sp
psclip \fB\-S \-O\fP > clip_mask_off.ps
.SH SEE ALSO
gmt, psbasemap, psmask
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
