.TH PSCONTOUR l "1 August 1995"
.SH NAME
pscontour \- Contour xyz-data by direct triangulation
.SH SYNOPSIS
\fBpscontour\fP \fIxyzfile\fP \fB\-C\fP\fIcptfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] 
[ \fB\-A\fP[\fBf\fP\fIfont_size\fP][\fBa\fP\fIangle\fP][\fI/r/g/b\fP][o]] ] [ \fB\-B\fP\fItickinfo\fP ] [ \fB\-D\fP[\fIdumpfile\fP] ] [ \fB\-E\fP\fIview_az/view_el\fP ] 
[ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-G\fP\fIgap\fP ] [ \fB\-H\fP ] [ \fB\-I\fP ] [ \fB\-K\fP ] 
[ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-T\fP\fIindexfile\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-W\fP\fIpen\fP ] [ \fB\-X\fP\fIx-shift\fP ] 
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP ] [ \fB\-b\fP[\fBd\fP] ]
.SH DESCRIPTION
\fBpscontour\fP reads an ASCII [or binary] xyz-file and produces a raw contour plot by triangulation.  By default, the
optimal Delaunay triangulation is performed, but the user may optionally provide a second file with
network information, such as a triangular mesh used for finite element modeling.  In addition to contours, the area between contours may be painted according to
the color palette file.
.TP
\fIxyzfile\fP
Raw xyz data to be contoured.
.TP
.B \-C
name of the color palette file.  Must have discrete colors if you want to paint the
surface (\fB\-G\fP).  Only contours that have anotation flags set will be anotated.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Several anotation formatting options can be set to modify the form of the annotation.  Append f\fIfont_size\fP to change font size [9], append \fI/r/g/b\fP to change color of text fill box
[PAGE_COLOR], append a\fIangle\fP to fix annotation angle [Default follows contour], and append 'o' to draw the outline of the surrounding text box [Default is no outline].
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-D
Dump the (x,y,z) coordinates of each contour to separate files, one for each contour segment. The
files will be named \fIdumpfile_cont_segment[_i]\fP.xyz, where \fIcont\fP is the contour value and
\fIsegment\fP is a running segment number for each contour interval (for closed contours we append _i.)
However, when \fB\-M\fP is used in conjunction with \fB\-D\fP a single multisegment file is created instead.
.TP
.B \-E
Sets the view point by specifying azimuth and elevation in degrees. [Default is 180/90]
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is black]
.TP
.B \-G
\fIgap\fP is distance in inch between each annotation along the same contour [Default is 4].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Color the triangles using the color palette table.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
When used in conjunction with \fB\-D\fP a single multisegment file is created, and
each contour section is preceeded by a header record whose first column is \fIflag\fP
followed by the contour level.
.B \-N
Do NOT clip contours or image at the boundaries [Defaults will clip to fit inside region \fB\-R\fP).
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-T
Give name of file with network information.  Each record must contain triplets of
node numbers for a triangle [Default computes these using Delaunay triangulation (see \fBtriangulate\fP)].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Select contouring and set contour pen attributes.
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-b
Expect binary, single precision triplets for xyz (and binary 4-byte integer triplets for node ids) rather than ASCII input.
[Default is ASCII].  Append \fBd\fP to indicate double precision for binary data [Default is single].
.SH EXAMPLES
To make a raw contour plot from the file topo.xyz and drawing the contours (pen = 2)
given in the color palette file topo.cpt on a Lambert map
at 0.5"/degree along the standard parallels 18 and 24, try 
.br
.sp
pscontour topo.xyz \fB\-R\fP320/330/20/30 \fB\-Jl\fP18/24/0.5 \fB\-C\fPtopo.cpt \fB\-W\fP2 > topo.ps
.br
.sp
To create a color \fIPostScript\fP plot of the numerical temperature solution obtained on a triangular mesh
whose node coordinates and temperatures are stored in temp.xyz and mesh arrangement is given by the file mesh.ijk, using
the colors in temp.cpt, try
.br
.sp
pscontour temp.xyz \fB\-R\fP0/150/0/100 \fB\-Jx\fP0.1 \fB\-C\fPtemp.cpt \fB\-G \-W\fP1 > temp.ps
.SH SEE ALSO
gmt, grdcontour, grdimage, nearneighbor, psbasemap, psscale, surface, triangulate
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
Watson, D. F., 1982, Acord: Automatic contouring of raw data, \fIComp. & Geosci., 8\fP, 97\-101.
.br
