.TH PSHISTOGRAM l "1 August 1995"
.SH NAME
pshistogram \- Bin data and plot histograms
.SH SYNOPSIS
\fBpshistogram\fB \fIfile\fP \fB\-Jx\fP\fIxscale[/yscale]\fP \fB\-W\fP\fIbin_width\fP [ \fB\-2\fP ] [ \fB\-B\fP\fItickinfo\fP ] 
[ \fB\-C\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP ] [ \fB\-I\fP ] 
[ \fB\-K\fP ] [ \fB\-L\fP\fIpen\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Q\fP ] 
[ \fB\-R\fIwest/east/south/north\fP ] [ \fB\-S\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V\fP ]  
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fItype\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBpshistogram\fP reads the first column from \fIfile\fP [or standard input] and
calculates histogram parameters based on the bin-width provided.  Using these parameters,
scaling, and optional range parameters it will generate \fIPostScript\fP code that plots a histogram.
A cumulative histogram may also be specified.  
.TP
\fIfile\fP
Input filename. If no file is given, pshistogram will read standard input.
.TP
.B \-Jx
\fIxscale[/yscale]\fP (Linear scale(s) in inch/unit).
.TP
.B \-W
Sets the bin width used for histogram calculations.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-2
Read second rather than first column.
.TP
.B \-C
Center bin on each value. [Default is left edge].
.TP
.B \-E
Sets the viewpoint's azimuth and elevation (for perspective view) [180/90]
.TP
.B \-G
Select filling of bars.  Set the shade (0\-255) or color (r/g/b) [Default is 0/0/0].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Draw bar outline using the specified pen thickness.  [Default is no outline].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-Q
Draw a cumulative histogram.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
If not given, \fBpshistogram\fP will automatically find reasonable values for the region.
.TP
.B \-S
Draws a stairs-step diagram instead of histogram.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-Z
Choose between 4 types of histograms: 0 = counts [Default], 1 = frequency_percent,
2 = log10 (1.0 + count), 3 = log10 (1.0 + frequency_percent).
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To draw a histogram of the data v3206.t containing seafloor depths, using a 250 meter
bin width, center bars, and draw bar outline, try:
.br
.sp
pshistogram v3206.t \fB\-W\fP250 \fB\-C \-L\fP2 \fB\-V\fP > plot.ps
.br
.sp
If you know the distribution of your data, you may explicitly specify range and scales.  E.g.,
to plot a histogram of the y-values (2nd column) in the file errors.xy using a 1 meter
bin width, plot from -10 to +10 meters @ 0.3 inch/m, annotate every 2 m and 100 counts,
and use black bars, try:
.br
.sp
cut -f2 errors.xy | pshistogram \fB\-W\fP1 \fB\-R\fP-10/10/0/0 \fB\-Jx\fP0.3/0.01
\fB\-B\fP2:Error:/100:Counts: \fB\-G\fP0 \fB\-V\fP > plot.ps
.br
.sp
Since no y-range was specified, pshistogram will calculate ymax in even increments of 100.
.SH SEE ALSO
gmt, psbasemap, psrose, psxy
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
