.TH PSMASK l "1 August 1995"
.SH NAME
psmask \- To clip or mask areas of no data on a map
.SH SYNOPSIS
\fBpsmask\fP [\fIxyzfile\fP] \fB\-I\fP\fIdx\fP[m|c][\fI/dy\fP[m|c]] \fB\-J\fP\fIparameters\fP 
\fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] [ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIradius\fP[m|c] ] 
[ \fB\-D\fP\fIdumpfile\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-G\fP\fIr/g/b\fP ] 
[ \fB\-H\fP ] [ \fB\-K\fP ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-S\fP ] [ \fB\-T\fP ] 
[ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] 
[ \fB\-c\fP\fIcopies\fP ]  [ \fB\-:\fP ] [ \fB\-b\fP[\fBd\fP] ]
.SH DESCRIPTION
\fBpsmask\fP reads a (x,y,z) file [or standard input] and uses this information to find out
which grid cells are reliable.  Only gridcells which have one or more data points are considered
reliable.  As an option, you may specify a radius of influence. Then, all gridcells that are
within \fIradius\fP of a data point are considered reliable.  Furthermore, an option is provided to
reverse the sense of the test.  Having found the reliable/not reliable points, \fBpsmask\fP will
either paint tiles to mask these nodes (with the \fB\-T\fP) switch, or use contouring to create
polygons that will clip out regions of no interest.
.TP
\fIxyzfile\fP
File with (x,y,z) values (e.g., that was used to run \fBsurface\fP).  If no file
is given, standard input is read.  For binary files, see \fB\-b\fP.
.TP
.B \-I
\fIdx\fP [and optionally \fIdy\fP] are the size of the gridblocks. Append m to indicate minutes, or c to indicate seconds.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments
.sp
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-C
Sets radius of influence. Grid nodes within \fIradius\fP of a data point are considered reliable. [Default is 0, which
means that only grid cells with data in them are reliable].  Append m to indicate minutes, or c to indicate seconds.
.TP
.B \-D
Dumps out the resulting clipping polygons to disk.  Ignored if \fB\-T\fP is set.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation for perspective plots [180/90]
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is black]
.TP
.B \-G
Paint the clip polygons [or tiles] with the gray-shade (0-255) or color (r/g/b, each 0-255) [Default is no fill]
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
Not used with binary data.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-N
Invert the sense of the test, i.e. clip regions where there is data coverage.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Mark end of existing clip path.  No input file is needed.  Implicitly sets \fB\-O\fP.
.TP
.B \-T
Plot tiles instead of clip polygons (Only works with \fB\-Jx\fP, \fB\-Jm\fP, \fB\-Jq\fP, and \fB\-Jy\fP).
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To make an overlay \fIPostScript\fP file that will mask out the regions of a contour map
where there is no control data using clip polygons, try:
.br
.sp
psmask africa_grav.xyg \fB\-R\fP20/40/20/40 \fB\-I\fP5m \fB\-J\fPM10 \fB\-O \-K\fP > mask.ps
.br
.sp
The same example but this time we use tiling:
.br
.sp
psmask africa_grav.xyg \fB\-R\fP20/40/20/40 \fB\-I\fP5m \fB\-J\fPM10 \fB\-T \-O \-K\fP > mask.ps
.SH SEE ALSO
gmt, surface, psbasemap, psclip
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
