.TH PSSCALE l "1 August 1995"
.SH NAME
psscale \- Create grayscale or colorscale for maps
.SH SYNOPSIS
\fBpsscale\fP \fB\-C\fP\fIcpt_file\fP \fB\-D\fP\fIxpos/ypos/length/width[h]\fP 
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-F\fP\fIred/green/blue\fP ] 
[ \fB\-I\fP[\fImax_intens\fP] ] [ \fB\-K\fP ] [ \fB\-L\fP ] [ \fB\-N\fP\fIdpi\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V \fP ] [ \fB\-X\fP\fIx-shift\fP ] 
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIzfile\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-0\fP || \fB\-1\fP || \fB\-2\fP ]
.SH DESCRIPTION
\fBpsscale\fP plots grayscales or colorscales on maps.  Both horizontal and vertical scales
are supported.  For cpt_files with gradational colors (i.e., the lower and upper
boundary of an interval have different r/g/b values) \fBpsscale\fP will interpolate to give
a continuous scale.  Variations in intensity due to shading/illumination may be
displayed by setting the option \fB\-I\fP.  Colors may be spaced according to a linear
scale, all be equal size, or by providing a file with individual tile widths.
.TP
.B \-C
\fIcpt_file\fP is the color palette file to be used
By default all color changes are anotated.  To use a subset, add an extra column to the
cpt-file with a L, U, or B to anotate Lower, Upper, or Both color segment boundaries.
.TP
.B \-D
Defines the position of the center/top (for horizontal scale) or center/left (for
vertical scale) and the dimensions of the scale.  Append \fIh\fP to get a horizontal
scale [Default is vertical].
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Here, only used to set the scale label, i.e., \fB\-B\fP:."Scale label:".  Note that since vertical labels will be plotted as a column
of individual characters, no octal escape characters imbedded in the label are allowed.
.TP
.B \-F
Sets the color used for Frame and annotations.  [Default is black]
.TP
.B \-I
Add illumination effects.  Optionally, set the range of intensities from
+ to - \fImax_intens\fP.  If not specify, 1.0 is used.  [Default is no illumination]
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Gives equal-sized color rectangles.  Default scales rectangles according to the
z-range in the cpt-file  (Also see \fB\-Z\fP).
.TP
.B \-N
Effective dots-per-inch for the rectangular image making up the color scale [50].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-Z
File with colorbar-width in inch per color entry.  By default, width of entry is scaled
to color range, i.e., z = 0-100 gives twice the width as z = 100-150 (Also see \fB\-L\fP).
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.TP
.B \-0
Create the scale using the Adobe \fIPostScript\fP colorimage operator.  This is the
\fBGMT\fP default (which can be modified in the .gmtdefaults file).
.TP
.B \-1
Create the scale by plotting individually colored tiles.
.TP
.B \-2
Create the scale by color separation using three calls to image for later
processing by \fBpsto24\fP.
.SH EXAMPLES
To append a vertical colorscale (3 inch long; 0.5 inch wide) to the right of a plot that is 6 inch wide and 4 inch
high, using illumination, try
.br
.sp
psscale \fB\-D\fP6.5/2/3/0.5 \fB\-O \-C\fPcolors.cpt \fB\-I\fP \fB\-B\fP:.BATHYMETRY: >> map.ps
.SH SEE ALSO
gmt, makecpt, grd2cpt
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
