.TH PSTEXT l "1 August 1995"
.SH NAME
pstext \- To plot textstrings on maps
.SH SYNOPSIS
\fBpstext\fP \fItextfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fIwest/east/south/north\fP[\fIr\fP] 
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIdx/dy\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] 
[ \fB\-G\fP\fIred/green/blue\fP ] [ \fB\-H\fP ] [ \fB\-K\fP ] [ \fB\-L\fP ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-S\fP\fIpen\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-W\fP[\fIred/green/blue\fP][\fBo\fP] ] 
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP ]
.SH DESCRIPTION
\fBpstext\fP plots textstrings of variable size, font type, and orientation.  Various map projections are
provided, with the option to draw and annotate the map boundaries. \fIPostScript\fP code is written to
standard output.  Greek characters, subscript, superscript, and small caps are supported as follows: The sequence @~ toggles
between the selected font and Greek (Symbol).  @%\fIno\fP% sets the font to \fIno\fP; @%% resets the
font to the starting font, @- toggles subscripts on/off, @+ toggles
superscript on/off, and @# toggles small caps on/off.  @@ prints the @ sign.  @e, @o, @a,
@E, @O, @A give the accented Scandinavian characters.  Composite characters (overstrike) may be
indicated with the @!<char1><char2> sequence, which will print the two characters on top of
each other.  To learn the octal codes for symbols not available on the keyboard and some accented European characters,
see Section 4.15 in the \fBGMT\fP Technical Reference and Cookbook.  Note that WANT_EURO_FONT must be set to TRUE in your .gmtdefaults file in order to use the accented characters.  Using the \fB\-W\fP option, a colored rectangle underlying the text may
be plotted  (Does not work for strings with sub/super scripts, symbols, or composite characters).
.TP
\fItextfile\fP
This file contains 1 or more records with (\fIx, y, size, angle, fontno, justify, text\fP).
If no file is given, \fBpstext\fP will read standard input.
\fIsize\fP is text size in points, \fIangle\fP is measured in degrees counter-clockwise from horizontal, 
\fIfontno\fP sets the font type, \fIjustify\fP sets the alignment. 
If \fIfontno\fP starts with a leading hyphen, then the remainder of \fIfontno\fP is taken to be a textstring with the desired fontname.  See the \fBgmtdefaults\fP man page
for names and numbers of avaiable fonts (or run \fBpstext \-L\fP).  The alignment number refers to the
part of the textstring that will be mapped onto the (\fIx,y\fP) point: 1 = Lower Left corner, 2 = Lower Center,
3 = Lower Right, 5 = Mid Left, 6 = Mid Center, 7 = Mid Right, 9 = Upper Left, 10 = Upper Center,
11 = Upper Right.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-C
Sets the clearance (in inch) between the text and the surrounding box [0.05/0.05].
Only used if \fB\-W\fP is specified.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation (for perspective view) [180/90]
.TP
.B \-F
Sets the color used for Frame and annotations.  [Default is black]
.TP
.B \-G
Sets the gray-shade (0-255) or color (r/g/b, each 0-255) used for drawing the text.  [Default is black]
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Lists the font-numbers and font-names available, then exits.
.TP
.B \-N
Do NOT clip text at map boundaries [Default will clip].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Draw text outline. Append pen attributes.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Paint a rectangle beneath the text string.  Set color [Default is 255/255/255 (white)].  Append o
to draw rectangle outline.
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the basemap [0].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To plot the outlines of the textstrings stored in the file text.d on a Mercator plot with
the given specifications, try
.br
.sp
pstext text.d \fB\-R\fP-30/30/-10/20 \fB\-Jm\fP0.1 \fB\-P \-B\fP5 \fB\-S\fP2 > plot.ps
.SH SEE ALSO
gmt, psbasemap
.SH BUGS
The horizontal justification of surrounding rectangles does not work when Greek symbols, sub- and
superscripts, and/or composite characters are imbedded in the textstring.
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
