.TH PSWIGGLE l "1 August 1995"
.SH NAME
pswiggle \- Plot anomaly along track on a map
.SH SYNOPSIS
\fBpswiggle\fP \fIxyz_files\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] 
\fB\-Z\fP\fIscale\fP [ \fB\-A\fP\fIdirection\fP ] [ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIcenter\fP ] [ \fB\-D\fP\fIgap\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] 
[ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-G\fP\fIfillrgb\fP ] [ \fB\-H\fP ] 
[ \fB\-I\fP\fIfix_az\fP ] [ \fB\-K\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-S\fP[x]\fIlon0/lat0/length\fP[\fIunits\fP] ] [ \fB\-T\fP\fItrack_pen\fP ] 
[ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V \fP ] [ \fB\-W\fP\fIwiggle_pen\fP ] [ \fB\-X\fP\fIx-shift\fP ] 
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP ]
.SH DESCRIPTION
\fBpswiggle\fP reads (x,y,z) triplets from files [or standard input] and plots z as a function of
distance along track.  This means that two consecutive (x,y) points define the local distance axis,
and the local z axis is then perpendicular to the distance axis.  The user may set a preferred
positive anomaly plot direction, and if the positive normal is outside
the plus/minus 90 degree window around the preferred direction, then 180 degrees are added to the
direction.  Either the positive or the negative wiggle may be shaded.  The resulting \fIPostScript\fP
code is written to standard output.
.TP
\fIfiles\fP
List one or more file-names. If no files are given, psxy will read standard input.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-Z
Gives anomaly scale in data-units/inch.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Sets the preferred positive direction.  Positive wiggles will "gravitate" towards that
direction.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-C
Subtract \fIcenter\fP from the data set before plotting [0].
.TP
.B \-D
Means there is a data gap if 2 consecutive points are more than \fIgap\fP distance
units apart.  For longitude/latitude data \fIgap\fP is in km, else it is in the
user's units.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation [180/90]
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is 0/0/0 (black)]
.TP
.B \-G
Gray shade or color for filling of positive anomalies.  Grayshade range from 0 (black) to 255 (white).
Color range from 0-255 for each of the rgb components. [Default is black]
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Set a fixed azimuth projection for wiggles [Default uses track azimuth, but see \fB\-A\fP].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fI<flag>\fP.
[Default is '>'].
.TP
.B \-N
Paint negative wiggles instead of positive [Default].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Draws a simple vertical scale centered on \fIlon0/lat0\fP.  Use \fB\-Sx\fP to specify cartesian coordinates instead.
\fIlength\fP is in z units, append unit name for labeling
.TP
.B \-T
Draw track  [Default is no track].  Append pen attributes to use [Defaults: width = 1, color = 0/0/0, texture = solid].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Draw wiggle outline  [Default is no outline].  Append pen attributes to use
[Defaults: width = 1, color = 0/0/0, texture = solid].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To plot the magnetic anomaly stored in the file track.xym along track @ 1000 nTesla/inch (after removing a mean value of 32000 Tesla),
using a 5-inch-wide Polar Stereographic map ticked
every 5 degrees in Portrait mode, with positive anomalies in red on a blue track of width 1, try
.br
.sp
pswiggle track.xym \fB\-R\fP-20/10/-80/-60 \fB\-JP\fP0/90/5 \fB\-Z\fP1000 \fB\-B\fP5 \fB\-P \-G\fP255/0/0 \fB\-T\fP1/0/0/255 \fB\-S\fP1000 \fB\-V\fP > track_xym.ps
.SH BUGS
Sometimes the (x,y) coordinates are not printed with enough significant
digits, so the local perpendicular to the track swings around a lot.  To
see if this is the problem, you should do this:
.br
.sp
awk '{ if (NR > 1) print atan2(y-$1, x-$2); y=$1; x=$2; }' yourdata.xyz | more
.br
.sp
(note that output is in radians; on some machines you need "nawk" to do this).
Then if these numbers jump around a lot, you may do this:
.br
.sp
gmtset D_FORMAT %.12lg
.br
awk '{ print NR, $0 }' yourdata.xyz | filter1d -Fb5 -N4/0 > smoothed.xyz
.br
.sp
and plot this data set instead.
.SH SEE ALSO
gmt, filter1d, psbasemap, splitxyz
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
