.TH PSXY l "1 August 1995"
.SH NAME
psxy \- Plot lines, polygons, and symbols on maps
.SH SYNOPSIS
\fBpsxy\fP \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fIr\fP] 
[ \fB\-A\fP ] [ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIcptfile\fP ] [ \fB\-E\fP\fI[x][y][cap][/pen]\fP ] 
[ \fB\-F\fP\fIred/green/blue\fP ] [ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP ] [ \fB\-K\fP ] [ \fB\-L\fP ] 
[ \fB\-N\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-S\fP\fIsymbol/size\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-W\fP\fIpen\fP ] 
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-:\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBpsxy\fP reads (x,y) pairs from \fIfiles\fP [or standard input] and
generates \fIPostScript\fP code that will plot lines, polygons, or symbols at those locations on a map.
If a symbol is selected and no symbol size given, then psxy will interpret the third column of the
input data as symbol size in inch.  Multiple segment files may be plotted using the \fB\-M\fP option.
If no symbols are selected, a line will be drawn.  To draw closed polygons, use \fB\-L\fP. Select a shade with \fB\-G\fP.  If \fB\-G\fP is set, \fB\-L\fP
will control whether the polygon outline is drawn or not.  If a symbol is selected, \fB\-G\fP and
\fB\-L\fP determines the fill color and outline/no outline, respectively.
The \fIPostScript\fP code is written to standard output. 
.TP
\fIfiles\fP
List one or more file-names. If no files are given, \fBpsxy\fP will read standard input.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Suppress drawing line segments as great circle Arcs.  [Default draws great circle arcs.]
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-C
Give a color palette file and let symbol color be determined by the z-value in the
third column.  Must be used with \fB\-S\fP.  If used, then additional fields are
shifted over by one column (optional size would be 4th rather than 3rd field, etc.).
.TP
.B \-E
Draw error bars.  Append x and/or y to indicate which bars you want to draw.  The x and/or
y errors must be stored in the columns after the (x,y) pair [or (x,y,size) triplet].  The
\fIcap\fP parameter indicates the length of the end-cap on the error bars in inch [0.1].  Pen
attributes for error bars may also be set.  [Defaults: width = 1, color = 0/0/0, texture = solid].
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is 0/0/0 (black)]
.TP
.B \-G
Select filling of polygons and symbols.  Set the shade (0\-255) or color (r/g/b) [Default is no fill].
For polygons, you may optionally specify \fB\-Gp\fP\fIicon_size/pattern\fP, where \fIpattern\fP gives the number of the
image pattern (1-32) OR the name of a icon-format file.  \fIicon_size\fP sets the unit size in inch.
To invert black and white pixels, use \fB\-GP\fP instead of \fB\-Gp\fP.  See \fBGMTs\fP Cookbook & Technical Reference
APpendix E for
information on individual patterns.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
If a symbol is selected, \fB\-L\fP will draw the symbol outline using current pen (see \fB\-W\fP).  If no symbols are selected, \fB\-L\fP will connect the endpoints of the line-segment(s) and draw polygons.
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Do NOT skip symbols that fall outside map border [Default plots points inside border only].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Plot symbols.  \fIsize\fP is symbol size in inch.  Choose between:
.TP
.B \-Sa
st\fBa\fPr.  \fIsize\fP is radius of circumscribing circle.
.TP
.B \-Sb
\fBb\fPar extending from \fIbase\fP to y.  \fIsize\fP is bar width.  By default,
\fIbase\fP = 0.  Append /\fIbase\fP to change this value.  Append \fBu\fP if \fIsize\fP
is in x-units [Default is inch].
.TP
.B \-Sc
\fBc\fPircle.  \fIsize\fP is diameter of circle.
.TP
.B \-Sd
\fBd\fPiamond.  \fIsize\fP is side of diamond.
.TP
.B \-Se
\fBe\fPllipse.  Direction (in degrees counterclockwise from horizontal), major_axis (in inch), and minor_axis (in inch) must be found in columns 3, 4, and 5.
.TP
.B \-Sf
\fBf\fPault.  Give distance gap between ticks and ticklength in inch.  If gap is
negative, it is interpreted to mean number of ticks instead.  Append \fBl\fP or \fBr\fP to draw tick on
the left or right side of line [Default is centered].  Upper case \fBL\fP or \fBR\fP draws a triangle
instead of line segment.
.TP
.B \-Sh
\fBh\fPexagon.  Give side in inch.
.TP
.B \-Si
\fBi\fPnverted triangle.  Give side in inch.
.TP
.B \-Sl
\fBl\fPetter or text string.  Give size in inch, and append /\fIstring\fP after the size.  Note that the size is only approximate; no individual scaling
is done for different characters.  Remember to escape special characters like *.
.TP
.B \-Sp
\fBp\fPoint.  No size needs to be specified (1 pixel is used).
.TP
.B \-Ss
\fBs\fPquare.  Give side in inch.
.TP
.B \-St
\fBt\fPriangle.  Give side in inch.
.TP
.B \-Sv
\fBv\fPector.  Direction (in degrees counterclockwise from horizontal) and length (in inch) must be found in columns 3 and 4.  \fIsize\fP,
if present, will be interpreted as arrowwidth/headlength/headwidth (in inch) [Default is 0.03/0.12/0.1 inch].
By default arrow attributes remains invariant to the length
of the arrow.  To have the size of the vector scale down with decreasing size,
append n\fPnorm\fP, where vectors shorter than \fInorm\fP will have their
attributes scaled by length/\fInorm\fP.
.TP
.B \-SV
Same as \fB\-Sv\fP, except azimuth (in degrees east of north) should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Sv\fP leaves the directions
unchanged.)
.TP
.B \-Sx
cross.  Give length in inch.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set pen attributes.  [Defaults: width = 1, color = 0/0/0, texture = solid]. 
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To plot solid red circles (diameter = 0.1 inch) at the positions listed in the file DSDP.xy on a
Mercator map at 2 inch/degree of the area 150E to 154E, 18N to 23N, with tickmarks every 1 degree
and gridlines every 15 minutes, try:
.br
.sp
psxy DSDP.xy \fB\-R\fP150/154/18/23 \fB\-Jm\fP2 \fB\-Sc\fP0.1 \fB\-G\fP255/0/0 \fB\-B\fP1g15m | lpr
.br
.sp
To plot the xyz values in the file quakes.xyzm as circles with size given by the magnitude in the
4th column and color based on the depth in the third using the color palette cpt on a linear map, try
.br
.sp
psxy quakes.xyzm \fB\-R\fP0/1000/0/1000 \fB\-JX\fP6 \fB\-Sc\fP \fB\-C\fPcpt \fB\-B\fP200 > map.ps
.br
.sp
To plot the file trench.xy on a Mercator map, with white triangles with sides 0.1 inch on the left side of the line, spaced every 0.8 inch, use
.br
.sp
psxy trench.xy \fB\-R\fP150/200/20/50 \fB\-Jm\fP0.15 \fB\-Sf\fP0.8/0.1L \fB\-G\fP255 \fB\-L \-B\fP10 | lpr
.SH SEE ALSO
gmt, psbasemap, psxyz
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
