.TH PSXYZ l "1 August 1995"
.SH NAME
psxyz \- Plot lines, polygons, and symbols in 3-D
.SH SYNOPSIS
\fBpsxyz\fB \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fIwest/east/south/north/zmin/zmax\fP[\fIr\fP] 
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIcptfile\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-F\fP\fIred/green/blue\fP ] 
[ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP ] [ \fB\-K\fP ] [ \fB\-L\fP ] [ \fB\-M\fP[\fIflag\fP] ] 
[ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-S\fP\fIsymbol/size\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-W\fP\fIpen\fP ] 
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-:\fP ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBpsxyz\fP reads (x,y,z) triplets from \fIfiles\fP [or standard input] and
generates \fIPostScript\fP code that will plot lines, polygons, or symbols at those locations in 3-D.
If a symbol is selected and no symbol size given, then psxyz will interpret the fourth column of the
input data as symbol size in inch.  Multiple segment files may be plotted using the \fB\-M\fP option.
If no symbols are selected, a line will be drawn.  To draw closed polygons, use \fB\-L\fP.  Select a shade with \fB\-G\fP.  If \fB\-G\fP is set, \fB\-L\fP
will control whether the polygon outline is drawn or not.  If a symbol is selected, \fB\-G\fP and
\fB\-L\fP determines the fill color and outline/no outline, respectively.
The \fIPostScript\fP code is written to standard output. 
.TP
\fIfiles\fP
List one or more file-names. If no files are given, \fBpsxyz\fP will read standard input.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-C
Give a color palette file and let symbol color be determined by the t-value in
the fourth column.  Must be used with \fB\-S\fP.  If used, then additional
fields are shifted over by one column (optional size would be in 5th rather than
4th field, etc.).
.TP
.B \-E
Sets the viewpoint's azimuth and elevation [180/90].
.TP
.B \-F
Sets the color used for Frame and annotation. [Default is 0/0/0 (black)]
.TP
.B \-G
Fill color.  Set the shade (0\-255) or color (r/g/b) [Default is no fill].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
If a symbol is selected, \fB\-L\fP will draw the symbol outline using current pen (see \fB\-W\fP).  If no symbols are selected, \fB\-L\fP will connect the endpoints of the line-sement(s) and draw polygons.
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP 
.B \-N 
Do NOT skip symbols that fall outside map border [Default plots points inside border only]. 
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Plot symbols.  \fIsize\fP is symbol size in inch.  Choose between:
.TP
.B \-Sb
(\fBb\fP)ar extending from \fIbase\fP to y.  \fIsize\fP is bar width.  By default,
\fIbase\fP = 0.  Append b\fIbase\fP to change this value.
.TP
.B \-Sc
(\fBc\fP)ircle.  \fIsize\fP is diameter of circle.
.TP
.B \-Sd
(\fBd\fP)iamond.  \fIsize\fP is side of diamond.
.TP
.B \-So
c(\fBo\fP)lumn (3-D) extending from \fIbase\fP to z.  \fIsize\fP sets base width (Use \fIxsize/ysize\fP if not the same).  By default,
\fIbase\fP = 0.  Append b\fIbase\fP to change this value.
.TP
.B \-Sp
(\fBp\fP)oint.  No size needs to be specified.
.TP
.B \-Ss
(\fBs\fP)quare.  Give side in inch.
.TP
.B \-St
(\fBt\fP)riangle.  Give side in inch.
.TP
.B \-Su
c(\fBu\fP)be (3-D).  \fIsize\fP sets length of all sides in inch.
.TP
.B \-Sv
(\fBv\fP)ector.  Direction and length (in inch) must be found in columns 4 and 5.
\fIsize\fP means \fIarrowwidth/headlength/headwidth\fP in (inch) [[Default is 0.03/0.12/0.1 inch].
By default arrow attributes remains invariant to the length
of the arrow.  To have the size of the vector scale down with decreasing size,
append n\fPnorm\fP, where vectors shorter than \fInorm\fP will have their
attributes scaled by length/\fInorm\fP.
.TP
.B \-SV
Same as \fB\-Sv\fP, except azimuth should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Sv\fP leaves the directions
unchanged.)
.TP
.B \-Sx
(\fBx\fP)cross. Give length in inch.
.br
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot in inch [Default is (-0.75,-0.75)].  Optionally,
append a label, or \fBc\fP (which will plot the command string.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set pen attributes.  [Defaults: width = 1, color = 0/0/0, texture = solid]
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP) inch  [Default is (1,1) for new plots, (0,0) for overlays].
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the basemap [0].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To plot blue columns (width = 0.5 inch) at the positions listed in the file heights.xyz on a
3-D projection of the space (0\-10), (0\-10), (0\-100),  with tickmarks every 2, 2, and 10,
viewing it from the southeast at 30 degree elevation, try:
.br
.sp
psxyz heights.xyz \fB\-R\fP0/10/0/10/0/100 \fB\-Jx\fP0.5 \fB\-Jz\fP0.05 \fB\-So\fP0.5
\fB\-G\fP0/0/255 \fB\-B\fP2:XLABEL:/2:YLABEL:/10:ZLABEL::."3-D PLOT":15 \fB\-E\fP135/30 \fB\-U\fPc
\fB\-L\fP \fB\-P\fP > heights.ps
.SH BUGS
No hidden line removal is employed for polygons and lines.  Symbols, however, are first sorted
according to their distance from the viewpoint so that nearby symbols will overprint more distant
ones should they project to the same x,y position.
.br
Header must be plotted separately using pstext.
.SH SEE ALSO
gmt, psbasemap, psxy
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
