.TH SAMPLE1D l "1 August 1995"
.SH NAME
sample1d -\ Resampling of 1-D data sets
.SH SYNOPSIS
\fBsample1d\fP \fIinfile\fP [ \fB\-A\fP ] [ \fB\-C\fP ] [ \fB\-H\fP ] [ \fB\-I\fP\fIxinc\fP ] [ \fB\-L\fP ] 
[ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP\fIknotfile\fP ] [ \fB\-S\fP\fIxstart\fP ] [ \fB\-T\fP\fIx-col\fP]  
.SH DESCRIPTION
\fBsample1d\fP reads a multi-column ASCII data set from file [or standard input] and resamples the
timeseries/profile at locations where the user needs the values.  The user must provide
the column number of the independent (monotonically increasing) variable.  Equidistant or arbitrary sampling can
be selected.  All columns are resampled based on the new sampling interval.
Several interpolation schemes are available.
.TP
\fIinfile\fP
This is a multi-column ASCII file with one column containing the independent variable (which must
be monotonically increasing) and the remaining columns holding misc. data values.
If no file is provided, sample1d reads from standard input.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Use Akima's spline for the interpolation (Quasi Hermite spline that does not introduce
artificial oscillations near outliers/sharp gradients in the data file) [Default].
.TP
.B \-C
Use a natural Cubic spline interpolant.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
\fIxinc\fP defines the sampling interval. [Default is the separation between the first and
second abcissa point in the \fIinfile\fP]
.TP
.B \-L
Use a Linear interpolant.
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
\fIknotfile\fP is an optional ASCII file with the x locations where the data set will be resampled in the first column
.TP
.B \-S
For equidistant sampling, \fIxstart\fP indicates the location of the first output value. [Default
is the smallest even multiple of \fIxinc\fP inside the range of \fIinfile\fP]
.TP
.B \-T
Sets the column number of the independent variable [Default is 0 (first)].
.SH EXAMPLES
To resample the file profiles.tdgmb, which contains (time,distance,gravity,magnetics,bathymetry) records,
at 1km equidistant intervals using Akima's spline, try
.br
.sp
sample1d profiles.tdgmb \fB\-I\fP1 \fB\-A\fP \fB\-T\fP1 > profiles_equi_d.tdgmb
.br
.sp
To resample the file depths.dt at positions listed in the file grav_pos.dg, using a cubic spline
for the interpolation, try
.br
.sp
sample1d depths.dt \fB\-N\fPgrav_pos.dg \fB\-C\fP > new_depths.dt
.SH SEE ALSO
gmt, filter1d
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
