.TH TRIANGULATE l "1 August 1995"
.SH NAME
triangulate \- Perform optimal Delauney triangulation and gridding
.SH SYNOPSIS
\fBtriangulate\fP \fIinfiles\fP [ \fB\-G\fP\fIgrdfile\fP ] [ \fB\-H\fP ] [ \fB\-I\fP\fIx_inc\fP[m|c][/\fIy_inc\fP[m|c]] ] [ \fB\-J\fP\fIparameters\fP ] [ \fB\-M\fP[\fIflag\fP] ] 
[ \fB\-R\fP\fIwest/east/south/north\fP ] [ \fB\-V\fP ] [ \fB\-Z\fP ] [ \fB\-:\fP ] [ \fB\-b\fP[\fBi|o\fP][\fBd\fP] ]
.SH DESCRIPTION
\fBtriangulate\fP reads one or more ASCII [or binary] files (or standard input) containing x,y[,z] and
performs Delauney triangulation, i.e., it find how the points should be connected to give
the most equilateral triangulation possible.  If a map projection is chosen then it is applied before
the triangulation is calculated.  By default, the output is triplets of point id numbers
that make up each triangle.  The id numbers refer to the points position in the input file.
As an option, you may choose to create a multiple segment file that can be piped through
\fBpsxy\fP to draw the triangulation network.  If \fB\G \-I\fP are set a grid will be calculated based
on the surface defined by the planar triangles.
.TP
\fIinfiles\fP
Data files with the point coordinates in ascii (or binary; see \fB\-b\fP).  If no files are given the standard input is read.
.SH OPTIONS
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] sets the grid  size for optional grid output (see \fB\-G\fP). Append m to indicate minutes or c to indicate seconds.
.TP
.B \-J
Selects the map projection. Scale is inch/degree, 1:xxxxx. or width in inch (upper case modifier).
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jm\fP\fIscale\fP (Mercator)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP\fIlon0/scale\fP (Eckert VI)
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP (Linear projection for polar (theta,r) coordinates)
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-M
Output triangulation network as multiple line segments separated by a record whose first
character is \fIflag\fP [>].  To plot, use \fBpsxy\fP with the \-M option (see Examples).
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-Z
Controls whether binary data file has two or three columns [2].  Ignored if \fB\-b\fP
is not set.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-b
Selects binary input and output mode.  Append \fBi\fP or \fBo\fP to select binary input or output only.  [Default
is ASCII].  Node ids are stored as binary 4-byte integer triplets.  Append \fBd\fP to indicate double precision for binary data
(if both binary input and output are selected they will have the same precision).  \fB\-bo\fP is ignored if \fB\-M\fP is selected.
.SH EXAMPLES
To triangulate the points in the file samples.xyz, store the triangle information in a binary file, and
make a grid for the given area and spacing, try
.br
.sp
triangulate samples.xyz \fB\-bo\fP \fB\-R\fP0/30/0/30 \fB\-I\fP2 \fB\-G\fPsurf.grd > samples.ijk
.br
.sp
To draw the optimal Delauney triangulation network based on the same file using a
6-inch-wide Mercator map, try
.br
.sp
triangulate samples.xyz \fB\-M \-R\fP-100/-90/30/34 \fB\-JM\fP6 | psxy \fB\-M \-R\fP-100/-90/30/34 \fB\-JM\fP6
\fB\-W\fP2 \fB\-B\fP1 > network.ps
.SH SEE ALSO
gmt, pscontour
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
Watson, D. F., 1982, Acord: Automatic contouring of raw data, \fIComp. & Geosci., 8\fP, 97\-101.
.br
