.TH XYZ2GRD l "1 August 1995"
.SH NAME
xyz2grd \- Converting an ASCII or binary table to grd file format
.SH SYNOPSIS
\fBxyz2grd\fP \fIxyzfile\fP \fB\-G\fP\fIgrdfile\fP \fB\-I\fP\fIx_inc\fP[m|c][/\fIy_inc\fP[m||cc]] 
\fB\-R\fP\fIwest/east/south/north\fP [ \fB\-D\fP\fIxunit/yunit/zunit/scale/offset/title/remark\fP ] 
[ \fB\-F\fP ] [ \fB\-H\fP ] [ \fB\-L\fP ] [ \fB\-N\fP\fInodata\fP ] [ \fB\-V\fP ] [ \fB\-Z\fP ] [ \fB\-:\fP ] [ \fB\-b\fP[\fBd\fP] ]
.SH DESCRIPTION
\fBxyz2grd\fP reads an ASCII [or binary] table with xyz triplets in the first 3 columns and
creates a binary grdfile.  xyz2grd will report if some of the nodes are not filled in with
data.  Such unconstrained nodes are set to a value specified by the user [Default is NaN].  As an option,
a 1-column z-table may be read assuming the ordering follows the scanline orientation and that all nodes
are present.
.TP
\fIxyzfile\fP
ASCII [or binary, see \fB\-b\fP] file holding (x,y,z) values in the first three columns for all the nodes.  The triplets do not
have to be sorted (unless \fB\-Z\fP is used). 
.TP
.B \-G
\fIgrdfile\fP is the name of the binary output grdfile.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the gridding interval.  Append m to indicate minutes, or c to indicate seconds.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.sp
.TP
.B \-D
Give values for \fIxunit, yunit, zunit, scale, offset, title,\fP and \fIremark\fP.
To leave some of these values untouched, specify = as the value.
.TP
.B \-F
Force pixel registration [Default is grid registration].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
Not used with binary data.
.TP
.B \-L
Indicates that the x column contains longitudes, which may differ from the regions in \fB\-R\fP by [multiples of] 360 degrees [Default assumes no periodicity].
.TP
.B \-N
No data.  Set nodes with no data to this value [Default is NaN].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-Z
Only read a 1-column ASCII [or binary] table.  This assumes that all the nodes are
present and sorted according to the scanline ordering convention.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.TP
.B \-b
Selects binary input mode (double precision) [Default is ASCII].
Append \fBd\fP to indicate double precision [Default is single].
.SH EXAMPLES
To create a grdfile from the ASCII data in hawaii_grv.xyz, try
.br
.sp
xyz2grd hawaii_grv.xyz \fB\-D\fPdegree/degree/mGal/1/0/"Hawaiian Gravity"/"GRS-80 Ellipsoid used"
\fB\-G\fPhawaii_grv_new.grd \fB\-R\fP198/208/18/25 \fB\-I\fP5m \fB\-V\fP
.br
.sp
To create a grdfile from the raw binary (single-precision) scanline-oriented data raw.b, try
.br
.sp
xyz2grd raw.b \fB\-D\fPm/m/m/1/0/=/= \fB\-G\fPraw.grd \fB\-R\fP0/100/0/100 \fB\-I\fP1 \fB\-V \-Z \-b\fP
.SH SEE ALSO
gmt, grd2xyz, grdedit
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 1995, The Generic Mapping Tools (GMT) version 3.0 Technical Reference & Cookbook,
SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, EOS Trans. AGU, 76, p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data, EOS Trans. AGU, 72, p. 441.
.br
