#-----------------	THE GMT-system:	@(#)makefile	1.57  11 Aug 1995	--------------------
#
#		Makefile for GMT Version 3.0 for OS/2
#
#	Follow the instructions in this makefile to customize your setup.
#	To compile/link them, try "make all", then "make install".
#	When done, clean out directory with "make clean".
#	For man pages, try "make man", then "make man_install"
#
#	Authors:	Paul Wessel, SOEST, U. of Hawaii
#             Walter H. F. Smith, N/OES12, NOAA
#
#	Date:		1-JUN-1995
#-------------------------------------------------------------------------------
#	Default setup
#-------------------------------------------------------------------------------
#
DRIVE = e:
AR	= ar
CC	= gcc
CFLAGS = -O 

#  Note CPP refers to the C pre-processor, not to the C++ compiler
CPP	= cpp
INSTALL = install -s
AR       = emxomfar
ARFLAGS  = rc
RANLIB	=
#-------------------------------------------------------------------------------
#====>>	I.  Set NETCDF, BINDIR, LIBDIR, and MANDIR before making anything!
#           Uncomment SI if you want SI units as defaults
#-------------------------------------------------------------------------------
#	NETCDF  -> Where to find netcdf sub-directories lib and include
#	BINDIR  -> Where to install executable code
#	LIBDIR  -> Where GMT support data files are installed.  THis path
#    		   must be hard, i.e., starting from root /
#	MANDIR  -> Where GMT manual pages are installed
#-------------------------------------------------------------------------------
#SI	= -DSI
NETCDF		= $(drive)/unix/netcdf
BINDIR		= $(drive)/unix/gmt/bin
LIBDIR		= $(drive)/unix/gmt/lib
MANDIR		= $(drive)/unix/gmt/man
#-------------------------------------------------------------------------------
NETCDFLIB	= $(NETCDF)/lib
NETCDFINC	= $(NETCDF)/include
#-------------------------------------------------------------------------------
#====>>	II. You may need to modify these macros
#-------------------------------------------------------------------------------
#
# UNcomment INSTALL on machines that DONT use standard BSD install
INSTALL	= copy

# UNcomment RANLIB on machines that DONT have ranlib.
#RANLIB	= touch

# UNcomment XDR if the xdr library must be included separately
# (Your xdr library may be called something else than -lsun)
XDR	= -lxdr

# UNcomment CC_OPT and set if you need machine-specific compiler switches
# (The current setting is _required_ for Dec Alphas)
# CC_OPT	= -ieee_with_inexact -Olimit 1500
#
CC_OPT =

#-------------------------------------------------------------------------------
#	!! STOP EDITING HERE, THE REST IS FIXED !!
#-------------------------------------------------------------------------------

PSL = -lpsl
GMT = -lgmt

SHELL=$(DRIVE)/os2/cmd.exe
PLACE	  = .
MAKE_OPTS = RANLIB=$(RANLIB) INSTALL=$(INSTALL) XDR=$(XDR)
CPFLAGS	  = -DDATE="\"08 November 1996\"" $(SI)
CFLAGS    = -O  -Zomf -Zsys -Zmt -Zstack 64000 -I$(NETCDFINC)  -DOS2_EMX $(SI) $(CC_OPT)
LDFLAGS = -Zlinker /PM:VIO 
#CFLAGS    = -O  -Zomf -Zsys -Zmt -I$(NETCDFINC) -DLIBDIR=\"$(LIBDIR)\"   $(SI) $(CC_OPT)
CDF	  = -L$(NETCDFLIB) -lnetcdf -lxdr
.SUFFIXES: .exe .c .obj .lib
.c.exe:
	$(CC) $(CFLAGS) $(LDFLAGS) $< -L. $(PSL) $(GMT) $(CDF)
#
LIB_C	= gmt_init.c \
	  gmt_plot.c \
	  gmt_support.c \
	  gmt_stat.c \
	  gmt_vector.c \
	  gmt_grdio.c \
	  gmt_customio.c \
	  gmt_cdf.c \
	  gmt_shore.c \
	  fourt.c \
	  gmt_map.c
LIB_O	= gmt_init.obj \
	  gmt_plot.obj \
	  gmt_support.obj \
	  gmt_stat.obj \
	  gmt_vector.obj \
	  gmt_grdio.obj \
	  gmt_customio.obj \
	  gmt_cdf.obj \
	  gmt_shore.obj \
	  fourt.obj \
	  gmt_map.obj
LIB 	= gmt_init \
	  gmt_plot \
	  gmt_support \
	  gmt_stat \
	  gmt_vector \
	  gmt_grdio \
	  gmt_customio \
	  gmt_cdf \
	  gmt_shore \
	  fourt \
	  gmt_map
GMT_H	= gmt.h \
	  gmt_shore.h \
	  gmt_project.h \
	  gmt_grd.h \
	  gmt_funcnames.h \
	  gmt_colors.h \
	  gmt_grdio.h \
	  gmt_customio.h \
	  gmt_bcr.h \
	  pslib.h

GMT_I	= gmt_init.h \
	  gmt_defaults.h \
	  PS_font_names.h \
	  PS_font_heights.h

PS_H	= pslib.h \
	  pslib_inc.h \
	  PS_font_names.h \
	  PS_font_heights.h
#
# Need to add grdmath to USER_x [before grdpaste]
#
USER = blockmean blockmedian filter1d fitcircle \
	  grdfilter gmtdefaults gmtset grd2cpt grd2xyz grdcontour grdcut grdclip grdedit \
	  grdfft grdgradient grdhisteq grdimage grdinfo grdlandmask grdmask grdtrack grdreformat \
	  grdpaste grdproject grdsample grdtrend grdvector grdview makecpt \
	  mapproject minmax nearneighbor project psbasemap psclip pscoast pshistogram \
	  psmask psmegaplot psrose psscale pstext pscontour pswiggle psxy psxyz \
	  sample1d spectrum1d splitxyz surface trend1d trend2d triangulate xyz2grd


USER_C = blockmean.c blockmedian.c filter1d.c fitcircle.c \
	  grdfilter.c gmtdefaults.c gmtset.c grd2cpt.c grd2xyz.c grdcontour.c grdcut.c grdclip.c grdedit.c \
	  grdfft.c grdgradient.c grdhisteq.c grdimage.c grdinfo.c grdlandmask.c grdmask.c grdtrack.c grdreformat.c \
	  grdpaste.c grdproject.c grdsample.c grdtrend.c grdvector.c grdview.c makecpt.c \
	  mapproject.c minmax.c nearneighbor.c project.c psbasemap.c psclip.c pscoast.c pshistogram.c \
	  psmask.c psmegaplot.c psrose.c psscale.c pstext.c pscontour.c pswiggle.c psxy.c psxyz.c \
	  sample1d.c spectrum1d.c splitxyz.c surface.c trend1d.c trend2d.c triangulate.c xyz2grd.c

USER_EXE = blockmean.exe blockmedian.exe filter1d.exe fitcircle.exe \
	  grdfilter.exe gmtdefaults.exe gmtset.exe grd2cpt.exe grd2xyz.exe grdcontour.exe grdcut.exe grdclip.exe grdedit.exe \
	  grdfft.exe grdgradient.exe grdhisteq.exe grdimage.exe grdinfo.exe grdlandmask.exe grdmask.exe grdtrack.exe grdreformat.exe \
	  grdpaste.exe grdproject.exe grdsample.exe grdtrend.exe grdvector.exe grdview.exe makecpt.exe \
	  mapproject.exe minmax.exe nearneighbor.exe project.exe psbasemap.exe psclip.exe pscoast.exe pshistogram.exe \
	  psmask.exe psmegaplot.exe psrose.exe psscale.exe pstext.exe pscontour.exe pswiggle.exe psxy.exe psxyz.exe \
	  sample1d.exe spectrum1d.exe splitxyz.exe surface.exe trend1d.exe trend2d.exe triangulate.exe xyz2grd.exe

LIBRARIES = gmt.lib psl.lib


#-------------------------------------------------------------------------------
#	object file dependencies
#-------------------------------------------------------------------------------

#LIB_O	= $(LIB_C)
	
#USER_O	= $(USER_C)
	
all:	libs $(USER_EXE)
	
install:	all
		for i in $(USER); do \
			$(INSTALL) $$i.exe $(BINDIR); \
		done
		copy fixgmtdefs $(BINDIR)

clean:
		delete  *.obj

#-------------------------------------------------------------------------------
#	libraries
#-------------------------------------------------------------------------------

libs:	psl.lib gmt.lib  

psl.lib:	pslib.obj
		$(AR) $(ARFLAGS) psl.lib $?

pslib.obj:	pslib.c $(PS_H)
		$(CC) $(CFLAGS) -c pslib.c

gmt_init.obj : gmt_init.c $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c gmt_init.c

gmt_plot.obj : gmt_plot.c $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c gmt_plot.c

gmt_support.obj : gmt_support.c $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c gmt_support.c

gmt_stat.obj : gmt_stat.c  $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c  gmt_stat.c

gmt_vector.obj :  gmt_vector.c $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c  gmt_vector.c

gmt_grdio.obj : gmt_grdio.c  $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c gmt_grdio.c

gmt_customio.obj : gmt_customio.c  $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c gmt_customio.c

gmt_cdf.obj : gmt_cdf.c  $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c gmt_cdf.c

gmt_shore.obj : gmt_shore.c  $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c gmt_shore.c

fourt.obj  :   fourt.c $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c fourt.c

gmt_map.obj : gmt_map.c  $(GMT_H) $(GMT_I)
	$(CC) $(CFLAGS) -c gmt_map.c

gmt.lib:	$(LIB_O)
		$(AR) $(ARFLAGS) $@ $?

#-------------------------------------------------------------------------------
#	program dependencies
#-------------------------------------------------------------------------------

$(USER) :	psl.lib gmt.lib libm.lib
		$(CC) $(CFLAGS)  $@.obj -L. $(PSL) $(GMT) $(CDF)

#-------------------------------------------------------------------------------
#	Man page management
#-------------------------------------------------------------------------------
#

MAN =  blockmean.man \
	blockmedian.man \
	filter1d.man \
	fitcircle.man \
	gmt.man \
	gmtdefaults.man \
	gmtset.man \
	grd2cpt.man \
	grd2xyz.man \
	grdfilter.man \
	grdclip.man \
	grdcontour.man \
	grdcut.man \
	grdedit.man \
	grdfft.man \
	grdgradient.man \
	grdhisteq.man \
	grdimage.man \
	grdinfo.man \
	grdlandmask.man \
	grdmask.man \
	grdmath.man \
	grdpaste.man \
	grdproject.man \
	grdreformat.man \
	grdsample.man \
	grdtrack.man \
	grdtrend.man \
	grdvector.man \
	grdview.man \
	makecpt.man \
	mapproject.man \
	minmax.man \
	nearneighbor.man \
	project.man \
	psbasemap.man \
	psclip.man \
	pscoast.man \
	pscontour.man \
	pshistogram.man \
	psmask.man \
	psmegaplot.man \
	psrose.man \
	psscale.man \
	pstext.man \
	pswiggle.man \
	psxy.man \
	psxyz.man \
	sample1d.man \
	spectrum1d.man \
	splitxyz.man \
	surface.man \
	trend1d.man \
	trend2d.man \
	triangulate.man \
	xyz2grd.man \
	pslib.man

M_INC = explain_-B.txt \
	explain_-b.txt \
	explain_-H.txt \
	explain_-J.txt \
	explain_-j.txt \
	explain_-Jz.txt \
	explain_-K.txt \
	explain_-O.txt \
	explain_-P.txt \
	explain_-R.txt \
	explain_-r.txt \
	explain_-U.txt \
	explain_-V.txt \
	explain_-XY.txt \
	explain_-c.txt \
	explain_-t.txt \
	refs.i

MANL	= $(MAN:.man=)

man:	$(MAN)

man_install:
		for i in $(MANL); do \
			copy $$i.man $(MANDIR)/$$i.l; \
		done

man_clean:
		del  *.man

%.man : %.txt
	$(CPP) $(CPFLAGS) $< | grep -v '^#' | gawk '( if (NF) print $0)' > $(@F:.txt=.man)
