/*--------------------------------------------------------------------
 *    The GMT-system:   @(#)gmt.h   2.48  07 Aug 1995
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * gmt.h is the main include file for the GMT-SYSTEM.  It contains definitions
 * for several of the structures and parameters used by the programs
 *
 * Author:   Paul Wessel
 * Date:   1-MAR-1991-1995
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include <pwd.h>
#include <time.h>
#include <sys/file.h>
#include <sys/types.h>

#ifndef NeXT
#include "values.h"  /* On unix systems, <values.h> should be used  */
#include <unistd.h>
#endif

/*     Definitions peculiar to OS/2 + EMX      */
#ifdef OS2_EMX
#include "gmt_os2.h"
#define log1p(x) log(1.0+(x))
#endif

#ifdef sony
typedef long time_t;
#endif

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define SMALL      1.0e-4   /* Needed when results aren't exactly zero but close */
#define GMT_SMALL_CHUNK   50
#define GMT_CHUNK   2000
#define GMT_VERSION   "3.0a:OS/2"        /*   For OS/2 + EMX   */
#define CNULL      ((char *)NULL)

#ifndef MIN
#define MIN(x, y) (((x) < (y)) ? (x) : (y))   /* min and max value macros */
#endif
#ifndef MAX
#define MAX(x, y) (((x) > (y)) ? (x) : (y))
#endif

#ifdef _UNICOS
#define copysign(x,y) ((y) < 0.0 ? -fabs(x) : fabs(x))
#define log1p(x) log (1.0+(x))
#endif
#ifdef hpux
#define copysign(x,y) ((y) < 0.0 ? -fabs(x) : fabs(x))
#define log1p(x) log (1.0+(x))
#endif
#ifdef aux
#define copysign(x,y) ((y) < 0.0 ? -fabs(x) : fabs(x))
#define log1p(x) log (1.0+(x))
#endif
#ifdef ultrix
#define copysign(x,y) ((y) < 0.0 ? -fabs(x) : fabs(x))
#define log1p(x) log (1.0+(x))
#endif
#ifdef dgux
#define log1p(x) log (1.0+(x))
#endif

/* Safe math macros that check arguments */

#define d_sqrt(x) ((x) < 0.0 ? 0.0 : sqrt (x))
#define d_acos(x) (fabs (x) >= 1.0 ? ((x) < 0.0 ? M_PI : 0.0) : acos (x))
#define d_asin(x) (fabs (x) >= 1.0 ? copysign (M_PI_2, (x)) : asin (x))
#define d_atan2(y,x) ((x) == 0.0 && (y) == 0.0 ? 0.0 : atan2 (y, x))
#define d_log(x) ((x) <= 0.0 ? gmt_NaN : log (x))
#define d_log10(x) ((x) <= 0.0 ? gmt_NaN : log10 (x))
#define d_log1p(x) ((x) <= -1.0 ? gmt_NaN : log1p (x))

/* Macros for degree-based trig */

#define sind(x) sin ((x) * D2R)
#define cosd(x) cos ((x) * D2R)
#define tand(x) tan ((x) * D2R)

/* Macros for rint (nearest integer), ceil (next higher integer), and floor (next lower integer) */

#define irint(x) ((int)((x) < 0.0 ? (x) - 0.5 : (x) + 0.5))
#define rint(x) ((double)irint((x)))
#define ceil(x) ((double)(int)((x) < 0.0 || (x) == (int)(x) ? (x) : (x) + 1.0))
#define floor(x) ((double)(int)((x) > 0.0 || (x) == (int)(x) ? (x) : (x) - 1.0))

/* Macros for swapping misc data types */

#define i_swap(x, y) {int tmp; tmp = x, x = y, y = tmp;}
#define d_swap(x, y) {double tmp; tmp = x, x = y, y = tmp;}
#define f_swap(x, y) {float tmp; tmp = x, x = y, y = tmp;}

/* Macro to detect a NaN */

#define bad_float(x) ((x) != (x))

/* Macro to create a NaN */

#ifdef __alpha
#define mknan(x) (((unsigned int *) &x)[0] = 0x7fffffff, ((unsigned int *) &x)[1] = 0xffffffff)
#endif

#ifdef sony
#define mknan(x) (((unsigned long *) &x)[0] = 0x7ff7ffff, ((unsigned long *) &x)[1] = 0x7ff7ffff)
#endif

#if !defined(mknan)
#define mknan(x) (((unsigned long *) &x)[0] = 0x7fffffff, ((unsigned long *) &x)[1] = 0xffffffff)
#endif

typedef int BOOLEAN;        /* BOOLEAN used for logical variables */
typedef int (*PFI) ();      /* PFI declares a pointer to a function returning an int */
typedef double (*PFD) ();   /* PFD declares a pointer to a function returning a double */

#include "gmt_project.h"    /* Define project_info and frame_info structures */
#include "gmt_grd.h"        /* Define grd file header structure */
#include "gmt_funcnames.h"  /* List of functions */
#include "gmt_colors.h"     /* Defines color/shading global structure */
#include "gmt_grdio.h"      /* Defines function pointers for grd i/o operations */

#define N_UNIQUE 49         /* Number of unique options */
#define N_KEYS 55           /* Number of gmt defaults */
#define N_FONTS 34          /* Number of fonts in the PS_font_names.h include file */
#define HASH_SIZE 61        /* Used in get_gmtdefaults, should be ~> N_KEYS */

/* This structure contains default parameters for the GMT system */

#define N_ELLIPSOIDS 13

#include "pslib.h"

struct GMTDEFAULTS {
   double anot_min_angle;          /* If angle between map boundary and anotation is less, no anot is drawn [20] */
   int anot_font;                  /* Font for anotations [Helvetica] */
   int anot_font_size;             /* Font size for anotations in points [14] */
   double anot_offset;             /* Distance between anotation and tickmarks [0.075] */
   char basemap_axes[5];           /* Which axes to draw and annotate ["WESN"]  */
   int basemap_frame_rgb[3];       /* Frame color rgb [(0,0,0) = black] */
   int basemap_type;               /* Fancy (0) or plain (1) [0] */
   int background_rgb[3];          /* Color of background [0/0/0] */
   int foreground_rgb[3];          /* Color of foreground [255/255/255] */
   int nan_rgb[3];                 /* Color of NaNs [0/0/0] */
   int color_image;                /* 0 = Adobe's colorimage, 1 = Tiles, 2 = RGB-separation */
   int color_model;                /* 0 = RGB, 1 = HSV [0] */
   char d_format[10];              /* Default double output format [%lg] */
   int degree_format;              /* 0 = <0/360/-90/90>, 1 = <-180/180/-90/90>, 2 = <0/180/0/90>          3 = 0E/180E/180W/0W/90S/90N> */
   int dpi;                        /* Dots pr. inch plotter resolution [300] */
   int ellipsoid;                  /* Which ellipsoid to use [0 = GRS 80] */
   int frame_pen;                  /* Pen thickness for map boundary [5] */
   double frame_width;             /* Thickness of fancy map frame [0.075] */
   double global_x_scale;          /* Scaling of x just before plotting [1] */
   double global_y_scale  ;        /* Scaling of y just before plotting [1] */
   double grid_cross_size;         /* Size of gridcrosses.  0 means draw continuous gridlines */
   int grid_pen;                   /* Pen thickness for gridlines [1] */
   int header_font;                /* Font for headers [Helvetica] */
   int header_font_size;           /* Font size for headers in points [36] */
   double hsv_min_saturation;      /* For smallest or most negative intensity [1.0] */
   double hsv_max_saturation;      /* For largest or most positive intensity [0.1] */
   double hsv_min_value;           /* For smallest or most negative intensity [0.3] */
   double hsv_max_value;           /* For largest or most positive intensity [1.0] */
   int interpolant;                /* Choose between 0 (Linear), 1 (Akima), or 2 (Cubic spline) */
   BOOLEAN io_header;              /* Input data has header records [FALSE] */
   int n_header_recs;              /* number of header records [0] */
   int label_font;                 /* Font for labels [Helvetica] */
   int label_font_size;            /* Font size for labels in points [24] */
   BOOLEAN last_page;              /* If TRUE, terminate plot system when done [TRUE] */
   double line_step;               /* Maximum straight linesegment length for arcuate lines */
   double map_scale_factor;        /* Central mapscale factor, typically 0.9996 */
   int measure_unit;               /* Choose 0 (cm), 1 (inch), or 2 (m) [1] */
   int n_copies;                   /* Number of copies pr plot [1] */
   int n_lat_nodes;                /* No of points to use for drawing a latitudal line [50] */
   int n_lon_nodes;                /* No of points to use for drawing a longitudal line [50] */
   double dlon, dlat;              /* Corresponding increment in lon/lat */
   int oblique_anotation;          /* Anotate all lon/lat marks (1),  or only longitudes on top/bottom boundary 
                                    * and latitudes on left/right boundary (0) [1] */
   BOOLEAN overlay;                /* Make plot in overlay mode [FALSE] */
   int page_rgb[3];                /* Color of the page [255/255/25 white] */
   int page_orientation;           /* Orientation of page [0 = Landscape, 1 = Portrait] */
   double paper_width;             /* Width of paper to plot on [8.5] */
   double ps_heximage;             /* TRUE gives hex ps output image, FALSE gives binary image [TRUE] */
   double tick_length;             /* Length of tickmarks [0.075] */
   int tick_pen;                   /* Pen thickness for tickmarks [2] */
   BOOLEAN unix_time;              /* Plot time and map projection on map [FALSE] */
   char unix_time_label[512];      /* Label to plot after time-stamp instead of command line */
   double unix_time_pos[2];        /* Where to plot timestamp relative to origin */
   double vector_shape;            /* 0.0 = straight vectorhead, 1.0 = arrowshape, with continuous range in between */
   BOOLEAN verbose;                /* Give info during execution [FALSE] */
   BOOLEAN want_euro_font;         /* Include re-encoding for European characters [TRUE] */
   double x_axis_length;           /* Length of x-axis if no scale is given [8] */
   double y_axis_length;           /* Length of y-axis if no scale is given [5] */
   double x_origin;                /* x-origin of plot, i.e. where lower left corner plots on paper [1] */
   double y_origin;                /* y-origin of plot, i.e. where lower left corner plots on paper [1] */
   BOOLEAN xy_toggle;              /* TRUE means read/write I/O as lat/lon instead of lon/lat [FALSE] */
   int y_axis_type;                /* Select y-axis with horizontal (0) or vertical (1) annotations  [0] */
   struct ELLIPSOID {              /* Information about a particular ellipsoid */
                                   /* Table taken from Snyder "Map projection - a working manual", p 12 Table 1 */
      char name[20];
      int date;
      double eq_radius;
      double pol_radius;
      double flattening;
   } ellipse[N_ELLIPSOIDS];        /* Ellipsoid parameters */
   
};

struct HASH {                      /* Used to related keywords to gmtdefaults entry */
   struct HASH *next;
   int id;
   char *key;
};

struct PEN {                       /* Holds pen attributes */
   int width;
   int r, g, b;
   int offset;
   char texture[20];
};

struct FILL {                      /* Holds fill attributes */
   BOOLEAN use_pattern;
   int r, g, b;
   int pattern_no;
   double icon_size;
   BOOLEAN inverse;
   char pattern[80];
};

/* Global variables */

char *gmt_program;                 /* Name of current GMT program */
extern int oldargc;
extern char *oldargv[];            /* Pointers to old common arguments */

/*   Current ellipsoid parameters */

extern double EQ_RAD, ECC, ECC2, ECC4, ECC6, M_PR_DEG;

extern struct GMTDEFAULTS gmtdefs;
extern struct MAP_PROJECTIONS project_info;
extern struct MAP_FRAME frame_info;
extern struct THREE_D z_project;

extern char *gmt_unit_names[];
extern double gmt_units[];
extern double gmt_ppu[];           /* Points per measure unit */
extern char *gmt_choice[];
extern char *font_name[];
extern double font_height[];
extern char *unique_option[];
extern char *gmt_keywords[];
extern int gmt_days_of_month[];

/*   For I/O purposes */

extern PFI gmt_input, gmt_output;
double gmt_data[BUFSIZ];
double grd_in_nan_value, grd_out_nan_value;

/*   For plotting purposes */

extern double *gmt_x_plot;         /* Holds the x/y (inches) of a line to be plotted */
extern double *gmt_y_plot;
extern int *gmt_pen;               /* Pen (3 = up, 2 = down) for these points */
extern int gmt_n_plot;             /* Number of such points */
extern int gmt_n_alloc;            /* Current size of allocated arrays */
extern int gmt_x_status_new;       /* Tells us what quadrant old and new points are in */
extern int gmt_y_status_new;
extern int gmt_x_status_old;
extern int gmt_y_status_old;
extern int gmt_corner;
extern BOOLEAN gmt_world_map;      /* TRUE if map has 360 degrees of longitude range */
extern BOOLEAN on_border_is_outside;   /* TRUE if a point exactly on the map border shoud be considered outside the map */
extern double gmt_map_width;       /* Full width of this world map */
extern double gmt_map_height;      /* Full height of this world map */
extern double gmt_half_map_size;   /* Half width of this world map */


extern PFI forward, inverse;       /*   Pointers to the selected mapping functions */
extern PFI x_forward, x_inverse;   /*   Pointers to the selected linear functions */
extern PFI y_forward, y_inverse;   /*   Pointers to the selected linear functions */
extern PFI z_forward, z_inverse;   /*   Pointers to the selected linear functions */
extern PFI outside;                /*   pointer to function checking if a lon/lat point is outside map */
extern PFI crossing;               /*   pointer to functions returning crossover point at boundary */
extern PFI overlap;                /*   pointer to function checking for overlap between 2 regions */
extern PFI map_clip;               /*   pointer to functions that clip a polygon to fit inside map */
extern PFD left_edge, right_edge;  /*   pointer to functions that returns the left,right edge of map */
extern PFD scan_time_string;       /*   pointer to functions that converts timestring to secs */

extern BOOLEAN gmt_quick;          /* TRUE if short usage message is desired (must say program - ) */

extern double gmt_NaN;             /*   Holds IEEE not-a-number value   */
