/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmt_funcnames.h	3.10  24 Jul 1995
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/

/* Functions that must be declared because they are assigned to a function pointer */

int linearxy();		/*	Convert x/y as linear, log10, or power	*/
int ilinearxy();	/*	Convert inverse x/y as linear, log10, or power	*/
int polar();		/*	Convert x/y (being theta,r) to x,y	*/
int ipolar();		/*	Convert (theta,r) to x,y	*/
int translin();		/*	Forward linear	*/
int translind();	/*	Forward linear, but using 0-360 degrees	*/
int itranslin();	/*	Inverse linear	*/
int translog10();	/*	Forward log10	*/
int itranslog10();	/*	Inverse log10	*/
int transpowx();	/*	Forward pow x	*/
int itranspowx();	/*	Inverse pow x	*/
int transpowy();	/*	Forward pow y 	*/
int itranspowy();	/*	Inverse pow y 	*/
int transpowz();	/*	Forward pow z 	*/
int itranspowz();	/*	Inverse pow z 	*/
int albers();		/*	Convert lon/lat to x/y (Albers)	*/
int ialbers();		/*	Convert x/y (Albers) to lon/lat	*/
int azeqdist();		/*	Convert lon/lat to x/y (Azimuthal equal-distance)	*/
int iazeqdist();	/*	Convert x/y (Azimuthal equal-distance) to lon/lat	*/
int cassini();		/*	Convert lon/lat to x/y (Cassini)	*/
int icassini();		/*	Convert x/y (Cassini) to lon/lat	*/
int hammer();		/*	Convert lon/lat to x/y (Hammer-Aitoff)	*/
int ihammer();		/*	Convert x/y (Hammer-Aitoff) to lon/lat	*/
int merc();		/*	Convert lon/lat to x/y (Mercator)	*/
int imerc();		/*	Convert x/y (Mercator) to lon/lat	*/
int plrs();		/*	Convert lon/lat to x/y (Polar)		*/
int iplrs();		/*	Convert x/y (Polar) to lon/lat		*/
int lamb();		/*	Convert lon/lat to x/y (Lambert)	*/
int ilamb();		/*	Convert x/y (Lambert) to lon/lat 	*/
int oblmrc();		/*	Convert lon/lat to x/y (Oblique Mercator)	*/
int ioblmrc();		/*	Convert x/y (Oblique Mercator) to lon/lat 	*/
int ortho();		/*	Convert lon/lat to x/y (ORTHO)	*/
int iortho();		/*	Convert x/y (ORTHO) to lon/lat 	*/
int sinusoidal();	/*	Convert lon/lat to x/y (SINUSOIDAL)	*/
int isinusoidal();	/*	Convert x/y (SINUSOIDAL) to lon/lat 	*/
int tm();		/*	Convert lon/lat to x/y (TM)	*/
int itm();		/*	Convert x/y (TM) to lon/lat 	*/
int utm();		/*	Convert lon/lat to x/y (UTM)	*/
int iutm();		/*	Convert x/y (UTM) to lon/lat 	*/
int winkel();		/*	Convert lon/lat to x/y (Winkel)	*/
int iwinkel();		/*	Convert x/y (Winkel) to lon/lat	*/
int eckert();		/*	Convert lon/lat to x/y (Eckert VI)	*/
int ieckert();		/*	Convert x/y (Eckert VI) to lon/lat	*/
int robinson();		/*	Convert lon/lat to x/y (Robinson)	*/
int irobinson();	/*	Convert x/y (Robinson) to lon/lat	*/
int stereo1();		/*	Convert lon/lat to x/y (Stereographic)	*/
int stereo2();		/*	Convert lon/lat to x/y (Stereographic, equatorial view)	*/
int istereo();		/*	Convert x/y (Stereographic) to lon/lat 	*/
int lambeq();		/*	Convert lon/lat to x/y (Lambert Azimuthal Equal-Area)	*/
int ilambeq();		/*	Convert x/y (Lambert Azimuthal Equal-Area) to lon/lat 	*/
int mollweide();	/*	Convert lon/lat to x/y (Mollweide Equal-Area)	*/
int imollweide();	/*	Convert x/y (Mollweide Equal-Area) to lon/lat 	*/
int cyleq();		/*	Convert lon/lat to x/y (Cylindrical Equal-Area)	*/
int icyleq();		/*	Convert x/y (Cylindrical Equal-Area) to lon/lat 	*/
int cyleqdist();	/*	Convert lon/lat to x/y (Cylindrical Equidistant)	*/
int icyleqdist();	/*	Convert x/y (Cylindrical Equidistant) to lon/lat 	*/
int x_to_xx();		/*	Generic linear x projection	*/ 
int xx_to_x();		/*	Generic inverse linear x projection	*/ 
int y_to_yy();		/*	Generic linear y projection	*/ 
int yy_to_y();		/*	Generic inverse linear y projection	*/ 
int z_to_zz();		/*	Generic linear z projection	*/ 
int zz_to_z();		/*	Generic inverse linear z projection	*/ 
int wesn_outside();		/*	Returns TRUE if a lon/lat point is outside map (rectangular wesn bounaries only)	*/
int polar_outside();		/*	Returns TRUE if a x'/y' point is outside the polar boundaries	*/
int rect_outside();		/*	Returns TRUE if a x'/y' point is outside the x'/y' boundaries	*/
int rect_outside2();		/*	Returns TRUE if a x'/y' point is outside the x'/y' boundaries (azimuthal maps only)	*/
int eqdist_outside();		/*	Returns TRUE if a x'/y' point is on the map perimeter 	*/
int radial_outside();		/*	Returns TRUE if a lon/lat point is outside the Lambert Azimuthal Eq. area boundaries	*/
int wesn_crossing();		/*	computes the crossing point between two lon/lat points and the map boundary between them */
int rect_crossing();		/*	computes the crossing point between two lon/lat points and the map boundary between them */
int radial_crossing();		/*	computes the crossing point between two lon/lat points and the circular map boundary between them */
int ellipse_crossing();		/*	computes the crossing point between two lon/lat points and the map boundary between them */
int eqdist_crossing();		/*	computes the crossing point between two lon/lat points and the map boundary between them */
int ellipse_clip();		/*	Returns TRUE if a x/y point is outside projected area	*/
int rect_clip();		/*	Clips to region based on rectangular xy coordinates	*/
int wesn_clip();		/*	Clips to region based on rectangular wesn coordinates	*/
int radial_clip();		/*	Clips to region based on spherical distance */
int wesn_overlap();		/*	Checks if two wesn regions overlap	*/
int rect_overlap();		/*	Checks if two xy regions overlap	*/
int radial_overlap();		/*	Currently a dummy routine	*/

double left_boundary();		/*	Returns x-value of left border for given y	*/
double right_boundary();	/*	Returns x-value of right border for given y	*/
double left_albers();		/*	For Albers maps	*/
double right_albers();		/*	For Albers maps	*/
double left_rect();		/*	For rectangular maps	*/
double right_rect();		/*	For rectangular maps	*/
double left_lambert();		/*	For Lambert maps	*/
double right_lambert();		/*	For Lambert maps	*/
double left_circle();		/*	For circular maps	*/
double right_circle();		/*	For circular maps	*/
double left_ellipse();		/*	For elliptical maps	*/
double right_ellipse();		/*	For elliptical maps	*/
double left_winkel();		/*	For Winkel maps	*/
double right_winkel();		/*	For Winkel maps	*/
double left_eckert();		/*	For Eckert VI maps	*/
double right_eckert();		/*	For Eckert VI maps	*/
double left_robinson();		/*	For Robinson maps	*/
double right_robinson();	/*	For Robinson maps	*/
double left_sinusoidal();	/*	For sinusoidal maps	*/
double right_sinusoidal();	/*	For sinusoidal maps	*/

/* Functions returning values other than integers */

char *memory();			/*	Allocates memory	*/

double great_circle_dist();	/*	Returns distance between two points in spherical degrees	*/
double gmt_half_map_width();	/* 	Get halfwidth as a function of y	*/
double	dot3v();		/*	Dot product of 3-D vectors	*/
double	mag3v();		/*	Returns magnitude of 3-D vector	*/
double	ln_gamma();		/*	Computes natural log of the gamma function	*/
double ddmmss_to_degree();	/*	Translates dd:mm:ss string to decimal degrees	*/

struct EPS *gmt_epsinfo();	/* 	Collects info needed for EPS header	*/

/* Functions passed as arguments to other functions */

int comp_double_asc();		/*	Used to sort doubles in ascending order	*/
int comp_float_asc();		/*	Used to sort floats in ascending order	*/
int comp_int_asc();		/*	Used to sort ints in ascending order	*/

/* I/O functions */

PFI gmt_input, gmt_output;

int ascii_input(), bin_double_input(), bin_float_input();
int ascii_output(), bin_double_output(), bin_float_output();
