/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmt_grd.h	3.3  2/17/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * grd.h contains the definition for a GMT-SYSTEM Version >= 2 grd file
 *
 * grd is stored in rows going from west (xmin) to east (xmax)
 * first row in file has yvalue = north (ymax).  
 * Author:	Paul Wessel
 * Date:	26-MAY-1990
 */
 
#include "netcdf.h"

/* Nodes that are unconstrained are assumed to be set to NaN */


struct GRD_HEADER {
	int nx;			/* Number of columns */
	int ny;			/* Number of rows */
	int node_offset;	/* 0 for node grids, 1 for pixel grids */
	double x_min;		/* Minimum x coordinate */
	double x_max;		/* Maximum x coordinate */
	double y_min;		/* Minimum y coordinate */
	double y_max;		/* Maximum y coordinate */
	double z_min;		/* Minimum z value */
	double z_max;		/* Maximum z value */
	double x_inc;		/* x increment */
	double y_inc;		/* y increment */
	double z_scale_factor;	/* grd values must be multiplied by this */
	double z_add_offset;	/* After scaling, add this */
	char x_units[80];	/* units in x-direction */
	char y_units[80];	/* units in y-direction */
	char z_units[80];	/* grid value units */
	char title[80];		/* name of data set */
	char command[320];	/* name of generating command */
	char remark[160];	/* comments re this data set */
};

/* Note on node_offset:
	Assume x_min = y_min = 0 and x_max = y_max = 10 and x_inc = y_inc = 1.
	For a normal node grid we have:
		(1) nx = (x_max - x_min) / x_inc + 1 = 11
		    ny = (y_max - y_min) / y_inc + 1 = 1
		(2) node # 0 is at (x,y) = (x_min, y_max) = (0,10) and represents the surface
		    value in a box with dimensions (1,1) centered on the node.
	For a pixel grid we have:
		(1) nx = (x_max - x_min) / x_inc = 10
		    ny = (y_max - y_min) / y_inc = 10
		(2) node # 0 is at (x,y) = (x_min + 0.5*x_inc, y_max - 0.5*y_inc) = (0.5, 9.5)
		    and represents the surface value in a box with dimensions (1,1)
		    centered on the node.
*/

		
