/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmt_init.h	2.19  2/17/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 *  This include file contains initializations for the GMT system
 *
 */

struct GMTDEFAULTS gmtdefs = {	/* Initial default values */
#include "gmt_defaults.h"
};

struct GMT_LUT *gmt_lut;

char *font_name[N_FONTS] = {
#include "PS_font_names.h"
};

double font_height[N_FONTS] = { /* Relative; based on the size of A devided by fontsize */
#include "PS_font_heights.h"
};

char *gmt_keywords[N_KEYS] = {
	"ANOT_MIN_ANGLE",
	"ANOT_FONT",
	"ANOT_FONT_SIZE",
	"ANOT_OFFSET",
	"BASEMAP_AXES",
	"BASEMAP_FRAME_RGB",
	"BASEMAP_TYPE",
	"COLOR_BACKGROUND",
	"COLOR_FOREGROUND",
	"COLOR_NAN",
	"COLOR_IMAGE",
	"COLOR_MODEL",
	"D_FORMAT",
	"DEGREE_FORMAT",
	"DOTS_PR_INCH",
	"ELLIPSOID",
	"FRAME_PEN",
	"FRAME_WIDTH",
	"GLOBAL_X_SCALE",
	"GLOBAL_Y_SCALE",
	"GRID_CROSS_SIZE",
	"GRID_PEN",
	"HEADER_FONT",
	"HEADER_FONT_SIZE",
	"HSV_MIN_SATURATION",
	"HSV_MAX_SATURATION",
	"HSV_MIN_VALUE",
	"HSV_MAX_VALUE",
	"INTERPOLANT",
	"IO_HEADER",
	"N_HEADER_RECS",
	"LABEL_FONT",
	"LABEL_FONT_SIZE",
	"LINE_STEP",
	"MAP_SCALE_FACTOR",
	"MEASURE_UNIT",
	"N_COPIES",
	"OBLIQUE_ANOTATION",
	"PAGE_COLOR",
	"PAGE_ORIENTATION",
	"PAPER_WIDTH",
	"PSIMAGE_FORMAT",
	"TICK_LENGTH",
	"TICK_PEN",
	"UNIX_TIME",
	"UNIX_TIME_POS",
	"VECTOR_SHAPE",
	"VERBOSE",
	"WANT_EURO_FONT",
	"X_AXIS_LENGTH",
	"Y_AXIS_LENGTH",
	"X_ORIGIN",
	"Y_ORIGIN",
	"XY_TOGGLE",
	"Y_AXIS_TYPE"
};

double gmt_units[3] = {0.01, 0.0254, 1.0};	/* No of meters in a cm, inch, m */
double gmt_ppu[3] = {72.0/2.54, 72.0, 72.0/0.0254};	/* No of points in a cm, inch, m */
char *gmt_unit_names[3] = {"cm", "inch", "m"};
char *gmt_choice[2] = {"OFF", "ON"};
char *unique_option[N_UNIQUE] = {
	"B", "JA", "Ja", "JB", "Jb", "JC", "Jc", "JE", "Je", "JG",
	"Jg", "JH", "Jh", "JI", "Ji", "JK", "Jk", "JL", "Jl", "JM",
	"Jm", "JN", "Jn", "JO", "Jo", "JP", "Jp", "JR", "Jr", "JS",
	"Js", "JT", "Jt", "JU", "Ju", "JW", "Jw", "Jx", "JX", "Jy",
	"JY", "Jz", "JZ", "R", "X", "x", "Y", "y", "#"
};
int gmt_days_of_month[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

int oldargc;
char *oldargv[N_UNIQUE];	/* Pointers to old common arguments */

double EQ_RAD, ECC, ECC2, ECC4, ECC6, M_PR_DEG;

/*	For plotting purposes */

double *gmt_x_plot = 0;	/* Holds the x/y (inches) of a line to be plotted */
double *gmt_y_plot = 0;
int *gmt_pen = 0;		/* Pen (3 = up, 2 = down) for these points */
int gmt_n_plot = 0;			/* Number of such points */
int gmt_n_alloc = 0;		/* Size of allocated arrays */
int gmt_x_status_new;		/* Tells us what quadrant old and new points are in */
int gmt_y_status_new;
int gmt_x_status_old;
int gmt_y_status_old;
int gmt_corner = 0;
BOOLEAN on_border_is_outside = FALSE;	/* TRUE if a point exactly on the map border shoud be considered outside the map */
BOOLEAN gmt_world_map = FALSE;	/* TRUE if map has 360 degrees of longitude range */
double gmt_map_width;		/* Full width in inches of this world map */
double gmt_map_height;		/* Full height in inches of this world map */
double gmt_half_map_size;	/* Half width in inches of this world map */
int gmt_n_colors = 0;
BOOLEAN gmt_gray;		/* TRUE if only grayshades are needed */
BOOLEAN gmt_b_and_w;		/* TRUE if only black and white are needed */
BOOLEAN gmt_continuous;		/* TRUE if continuous color tables have been given */
BOOLEAN gmt_quick = FALSE;

PFI forward, inverse;		/*	Pointers to the selected mapping functions */
PFI x_forward, x_inverse;	/*	Pointers to the selected linear functions */
PFI y_forward, y_inverse;	/*	Pointers to the selected linear functions */
PFI z_forward, z_inverse;	/*	Pointers to the selected linear functions */
PFI outside;			/*	pointer to function checking if a lon/lat point is outside map */
PFI crossing;			/*	pointer to functions returning crossover point at boundary */
PFI overlap;			/*	pointer to function checking for overlap between 2 regions */
PFI map_clip;			/*	pointer to functions that clip a polygon to fit inside map */
PFD left_edge, right_edge;	/*	pointers to functions that return left/right edge of map */

PFI gmt_input;			/* Pointer to function reading ascii or binary tables */
PFI gmt_output;			/* Pointer to function writing ascii or binary tables */

struct MAP_PROJECTIONS project_info;
struct MAP_FRAME frame_info;
struct THREE_D z_project;

double gmt_NaN;

int grd_i_format = 0;		/* Default is GMT's cdf format */
int grd_o_format = 0;
double grd_in_nan_value, grd_out_nan_value;
