/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmt_project.h	3.4  09 Aug 1995
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * Include file for programs that use the map-projections functions.  Note
 * that most programs will include this by including gmt.h
 *
 * Author:	Paul Wessel
 * Date:	26-FEB-1990
 *
 */

#define LINEAR		0	/* Linear projections tagged 0-9 */
#define LOG10		1
#define POW		2
#define MERCATOR	10	/* Cylindrical projections tagged 10-99 */
#define OBLIQUE_MERC	11
#define TM		12
#define UTM		13
#define CASSINI		14
#define	CYL_EQ		15
#define	CYL_EQDIST	16
#define STEREO		100	/* Azimuthal projections tagged 100-999 */
#define LAMB_AZ_EQ	101
#define ORTHO		102
#define AZ_EQDIST	103
#define POLAR		110
#define LAMBERT		1000	/* Conic projections tagged 1000-9999 */
#define ALBERS		1001
#define MOLLWEIDE	10000	/* Misc projections tagged 10000-99999 */
#define HAMMER		10001
#define SINUSOIDAL	10002
#define WINKEL		10003
#define ROBINSON	10004
#define ECKERT		10005

#define MAPPING (project_info.projection > 5 || project_info.pars[4] == 1.0)	/* TRUE when map projections are used */
#define CYLINDRICAL (project_info.projection >= 10 && project_info.projection < 100)
#define AZIMUTHAL (project_info.projection >= 100 && project_info.projection < 1000)
#define CONICAL (project_info.projection >= 1000 && project_info.projection < 10000)
#define RECT_GRATICULE (project_info.projection == MERCATOR || project_info.projection == CYL_EQ || project_info.projection == CYL_EQDIST)

#define D2R (M_PI / 180.0)
#define R2D (180.0 / M_PI)

struct MAP_PROJECTIONS {

	double pars[10];		/* Raw unprocessed map-projection parameters as passed on command line */
	double z_pars[2];		/* Raw unprocessed z-projection parameters as passed on command line */
	
	/* Common projection parameters */
	
	int projection;			/* Gives the id number for the projection used */
	
	BOOLEAN x_off_supplied;		/* Used to set xorigin/yorigin for overlay/final plots */
	BOOLEAN y_off_supplied;
	BOOLEAN region_supplied;	/* TRUE when -R option has been given */
	BOOLEAN units_pr_degree;	/* TRUE if scale is given as inch (or cm)/degree.  FALSE for 1:xxxxx */
	BOOLEAN gave_map_width;		/* TRUE if map width in inch (or cm) is given instead of scale.  FALSE for 1:xxxxx */
	BOOLEAN region;			/* TRUE if -R gives lon/lat boundaires, FALSE if it gives lower/left upper right corners */
	BOOLEAN north_pole;		/* TRUE if projection is on northern hermisphere, FALSE on southern */
	BOOLEAN edge[4];		/* TRUE if the edge is a map boundary */
	BOOLEAN three_D;		/* Parameters for 3-D projections */

	double x0, y0, z0;		/* Projected values of the logical origin for the projection */
	double xmin, xmax, ymin, ymax, zmin, zmax;	/* Extreme projected values */
	double w, e, s, n;		/* Bounding geographical region, if applicable */
	double z_bottom, z_top;		/* Bounds in z direction */
	double x_scale, y_scale;	/* Scaling for meters to map-distance (typically inch) conversion */
	double z_scale;			/* Scale for z projection (user-units to map-units (typically inch) */
	double z_level;			/* Level at which to draw basemap [0] */
	double unit;			/* Gives meters pr plot unit (0.01 or 0.0254) */
	double central_meridian;	/* Central meridian for projection */
	double pole;			/* +90 pr -90, depending on which pole */
	
	
	/* Linear plot parameters */
	
	int xyz_projection[3];		/* For linear projection, 0 = linear, 1 = log10, 2 = pow */
	BOOLEAN xyz_pos[3];		/* TRUE if x,y,z-axis increases in normal positive direction */
	BOOLEAN compute_scale[3];	/* TRUE if axes lengths were set rather than scales */
	double xyz_pow[3];		/* For POW projection */
	double xyz_ipow[3];
	
	/* Lambert conformal conic parameters.  (See Snyder for details on all parameters) */
	
	double l_N;
	double l_F;
	double l_rho0;
	
	/* Oblique Mercator Projection (Spherical version )*/
	
	double o_sin_pole_lat, o_cos_pole_lat;	/* Pole of rotation */
	double o_pole_lon;	/* In Radians */
	double o_beta;		/* lon' = beta for central_meridian (In Radians) */
	
	/* TM and UTM Projections */
	
	double t_e2;
	double t_c1, t_c2, t_c3, t_c4;
	double t_ic1, t_ic2, t_ic3, t_ic4;
	
	/* Lambert Azimuthal Equal-Area Projection */
	
	double sinp;
	double cosp;
	
	/* Stereographic Projection */
	
	double s_cosz1, s_sinz1;
	double s_c;
	double r;		/* Radius of projected sphere in plot units (inch or cm) */
	BOOLEAN polar;		/* True if projection pole coincides with S or N pole */
	
	/* Mollweide Equal-Area Projection */
	
	double w_x;
	double w_y;
	double w_r;	/* Also used by Hammer-Aitoff and Winkel Projections */
	
	/* Winkel Tripel Projection */
	
	double r_cosphi1;	/* = cos (50.467) */
	
	/* Robinson Projection */
	
	double n_cx, n_cy;	/* = = 0.8487R, 1.3523R */
	double n_phi[19], n_X[19], n_Y[19];
	
	/* Eckert VI Projection */
	
	double k_r, k_ir;
	
	/* Cassini Projection */
	
	double c_M0;
	
	/* Cylindrical equal-area Projection(s) */
	
	double y_rx, y_ry;
	
	/* Albers Equal-area conic parameters. */
	
	double a_n;
	double a_C;
	double a_rho0;
	
};

struct MAP_FRAME {		/* Various parameters for plotting of map boundaries */
	double frame_int[3];	/* x,y,z */
	double grid_int[3];
	double anot_int[3];
	char label[3][100];
	char header[100];
	int side[5];		/* Which sides to plot. 2 is anot/draw, 1 is draw, 0 is not */
	int anot_type[3];	/* For log10 and pow anotations only */
	BOOLEAN plot;		/* TRUE if frame is desired */
	BOOLEAN draw_box;	/* TRUE if 3-D supporting frame is desired */
	BOOLEAN check_side;	/* TRUE if lon and lat anotations should be on x and y axis only */
	BOOLEAN horizontal;	/* TRUE is S/N anotations should be parallel to axes */
};

struct THREE_D {
	double view_azimuth, view_elevation;
	double cos_az, sin_az, cos_el, sin_el;
	double corner_x[4], corner_y[4];
	double xmin, xmax, ymin, ymax;
	double phi[3];		/* Angle each axis makes with horizontal */
	double xshrink[3];	/* Shrinkage in x-dir due to projection */
	double yshrink[3];	/* Same for y-dir */
	double tilt[3];		/* Slant of characters due to projection */
	double sign[4];		/* Used to determine direction of tickmarks etc */
	int quadrant;		/* quandrant we're looking from */
	int z_axis;		/* Which z-axis to draw. */
	int k;			/* For drawing-axis. 0 = plot in x dir, 1 in y */
	int face[3];		/* Tells if this facet has normal in pos direction */
	int draw[4];		/* axes to draw */
};
