/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmt_shore.h	3.4  26 Jun 1995
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
#include "netcdf.h"

#define MAX_DELTA 65535	/* Largest value to store in a ushort, used as largest dx or dy in bin  */
#define MAX_LEVEL	4

#define N_BLEVELS	3
#define N_RLEVELS	10

typedef unsigned char uchar;

typedef unsigned short int ushort; /* Added by Allen Cogbill, 9/22/96  */

struct SHORE {

	/* Global variables that remain fixed for all bins */
	
	int nb;			/* Number of bins to use */
	int *bins;		/* Array with the nb bin numbers to use */
	double scale;		/* Multiplier to convert dx, dy back to dlon, dlat in degrees */
	
	/* Variables associated with the current bin */
	
	int ns;			/* Number of segments to use in current bin */
	uchar node_level[4];
	struct SHORE_SEGMENT *seg;	/* Array of these segments */
	struct SIDE *side[4];		/* Has position & id for each side exit/entry */
	int nside[4];			/* Number of entries per side, including corner */
	int n_entries;
	double bsize;			/* Size of square bins in degrees */
	double lon_sw;			/* Longitude of SW corner */
	double lat_sw;			/* Latitude of SW corner */
	double lon_corner[4];		/* Longitudes of 4 corners (depends on direction) */
	double lat_corner[4];		/* Latitudes of 4 corners (depends on direction) */

	/* Data variables associated with shoreline database */
	
	nclong bin_size;	/* Size of square bins in minutes */
	nclong bin_nx;		/* Number of bins in 360 degrees of longitude */
	nclong bin_ny;		/* Number of bins in 180 degrees of latitude */
	nclong n_bin;		/* Number of bins present in the data set */
	nclong n_seg;		/* Number of segments present in the data set */
	nclong n_pt;		/* Number of points present in the data set */
	
	nclong *bin_firstseg;	/* Array with ids of first segment per bin */
	short *bin_info;	/* Array with levels of all 4 nodes per bin */
	short *bin_nseg;	/* Array with number of segments per bin */
	
	char units[80];		/* Units of lon/lat */
	char title[80];		/* Title of data set */
	char source[80];	/* Source of data set */

	/* Netcdf ID variables */
	
	int cdfid;		/* File id for coastbin file */
	
	int bin_size_id;	/* Id for variable bin_size */
	int bin_nx_id;		/* Id for variable bin_nx */
	int bin_ny_id;		/* Id for variable bin_ny */
	int n_bin_id;		/* Id for variable n_bin */
	int n_seg_id;		/* Id for variable n_seg */
	int n_pt_id;		/* Id for variable n_pt */
	int bin_firstseg_id;	/* Id for variable bin_firstseg */
	int bin_info_id;	/* Id for variable bin_info */
	int bin_nseg_id;	/* Id for variable bin_nseg */
	
	int seg_info_id;	/* Id for variable seg_info */
	int seg_area_id;	/* Id for variable seg_area */
	int seg_start_id;	/* Id for variable seg_start */
	
	int pt_dx_id;		/* Id for variable pt_dx */
	int pt_dy_id;		/* Id for variable pt_dy */
	
};

struct SHORE_SEGMENT {
	uchar level;	/* Level of polygon segment (1 i ocean/land, 2 = land/lake, 3 = lake/island, etc) */
	uchar entry;	/* Side (0-3) the segment starts on, or 4 for closed segments */
	uchar exit;	/* Side (0-3) the segment ends on, or 4 for closed segments */
	ushort n;	/* Number of points in segment */
	short *dx;	/* Array of scaled longitudes relative to SW corner */
	short *dy;	/* Array of scaled latitudes relative to SW corner */
};

struct SIDE {
	ushort pos;	/* Position along side in 0-65535 range */
	short id;	/* Local segment id */
};

struct BR {	/* Structure for Borders and Rivers */

	/* Global variables that remain fixed for all bins */
	
	int nb;			/* Number of bins to use */
	int *bins;		/* Array with the nb bin numbers to use */
	double scale;		/* Multiplier to convert dx, dy back to dlon, dlat in degrees */
	
	/* Variables associated with the current bin */
	
	int ns;			/* Number of segments to use in current bin */
	struct BR_SEGMENT *seg;	/* Array of these segments */
	double lon_sw;			/* Longitude of SW corner */
	double lat_sw;			/* Latitude of SW corner */
	double bsize;			/* Size of square bins in degrees */

	/* Data variables associated with shoreline database */
	
	nclong bin_size;	/* Size of square bins in minutes */
	nclong bin_nx;		/* Number of bins in 360 degrees of longitude */
	nclong bin_ny;		/* Number of bins in 180 degrees of latitude */
	nclong n_bin;		/* Number of bins present in the data set */
	nclong n_seg;		/* Number of segments present in the data set */
	nclong n_pt;		/* Number of points present in the data set */
	
	nclong *bin_firstseg;	/* Array with ids of first segment per bin */
	short *bin_nseg;	/* Array with number of segments per bin */
	
	char units[80];		/* Units of lon/lat */
	char title[80];		/* Title of data set */
	char source[80];	/* Source of data set */

	/* Netcdf ID variables */
	
	int cdfid;		/* File id for coastbin file */
	
	int bin_size_id;	/* Id for variable bin_size */
	int bin_nx_id;		/* Id for variable bin_nx */
	int bin_ny_id;		/* Id for variable bin_ny */
	int n_bin_id;		/* Id for variable n_bin */
	int n_seg_id;		/* Id for variable n_seg */
	int n_pt_id;		/* Id for variable n_pt */
	int bin_firstseg_id;	/* Id for variable bin_firstseg */
	int bin_nseg_id;	/* Id for variable bin_nseg */
	
	int seg_n_id;		/* Id for variable seg_n */
	int seg_level_id;	/* Id for variable seg_level */
	int seg_start_id;	/* Id for variable seg_start */
	
	int pt_dx_id;		/* Id for variable pt_dx */
	int pt_dy_id;		/* Id for variable pt_dy */
	
};

struct BR_SEGMENT {
	ushort n;	/* Number of points in segment */
	ushort level;	/* Hierarchial level of segment */
	short *dx;	/* Array of scaled longitudes relative to SW corner */
	short *dy;	/* Array of scaled latitudes relative to SW corner */
};

struct POL {
	int n;
	int interior;	/* TRUE if polygon is inside bin */
	int level;
	double *lon;
	double *lat;
};
