/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmtdefaults.c	2.11  2/4/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * gmtdefaults will list the users default settings for the GMT-SYSTEM or
 * (by using the -D option), get the GMT-SYSTEM's default settings.
 *
 * Author:	Paul Wessel
 * Date:	1-MAY-1991-1995
 * Version:	2.0
 */
 
#include "gmt.h"

main (argc, argv)
int argc;
char **argv; {
	int i;
	
	BOOLEAN error = FALSE, get_sys_defaults = FALSE, get_user_defaults = FALSE;
	
	for (i = 1; !error && i < argc; i++) {
		if (argv[i][0] != '-') continue;
		switch (argv[i][1]) {
			case '\0':
				error += get_common_args (argv[i], 0, 0, 0, 0);
				break;
			case 'D':	/* Get GMT defaults settings */
				get_sys_defaults = TRUE;
				break;
			case 'L':	/* List the user's current GMT defaults settings */
				get_user_defaults = TRUE;
				break;
			default:
				error = TRUE;
                                gmt_default_error (argv[i][1]);
				break;
		}
	}
	
	if (argc == 1 || gmt_quick) {
		fprintf (stderr, "gmtdefaults %s - List GMT-SYSTEM default parameters\n\n", GMT_VERSION);
		fprintf (stderr, "usage: gmtdefaults [-D | -L]\n\n");
		if (gmt_quick) exit (-1);
		fprintf (stderr, "	-D prints the default settings for the GMT system\n");
		fprintf (stderr, "	-L prints the users current GMT default settings\n");
		exit (-1);
	}
	
	if (!(get_user_defaults || get_sys_defaults)){
		fprintf (stderr, "%s: GMT SYNTAX ERROR: Must specify one of -D or -L\n", gmt_program);
		error++;
	}
	
	if (error) exit (-1);
	
	if (get_user_defaults) get_gmtdefaults (CNULL);
	
	gmt_savedefaults (CNULL);

	exit (0);
}
