/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)grdclip.c	2.16  3/13/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
   grdclip read a grdfile and sets all values < the user-supplied
   lower limit to the value <below>, and all values > the user-
   supplied upper limit to the value <above>.  above/below can
   be any number of gmt_NaN.

   WHF Smith, 22 Aug 88
   Modified for v2.0 4/26/91 P.Wessel
 
 */


#include "gmt.h"

float *data;

main (argc, argv)
int argc;
char **argv; {

	int	error, set_above, set_below, i, nxy, n_above, n_below, n, dummy[4];
	float	above, below, low, high;
	char *infile, *outfile;
	struct GRD_HEADER header;

	argc = gmt_begin (argc, argv);

	error = set_above = set_below = FALSE;
	n_above = n_below = 0;
	low = high = 0.0;
	dummy[3] = dummy[2] = dummy[1] = dummy[0] = 0;

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				/* Common parameters */
			
				case 'V':
				case '\0':
					error += get_common_args (argv[i], 0, 0, 0, 0);
					break;
				
				/* Supplemental parameters */
			
				case 'A':
					set_above = TRUE;
					n = sscanf (&argv[i][2], "%f/%f", &high, &above);
					if (n == 0) {
						fprintf (stderr, "%s: GMT SYNTAX ERROR -A option.  Correct syntax:\n", gmt_program);
						fprintf (stderr, "\t-A<high>/<above>, <above> may be set to NaN\n");
						error = TRUE;
					}
					else if (n == 1) above = gmt_NaN;
					break;
				case 'B':
					set_below = TRUE;
					n = sscanf (&argv[i][2], "%f/%f", &low, &below);
					if (n == 0) {
						fprintf (stderr, "%s: GMT SYNTAX ERROR -B option.  Correct syntax:\n", gmt_program);
						fprintf (stderr, "\t-B<low>/<below>, <below> may be set to NaN\n");
						error = TRUE;
					}
					else if (n == 1) below = gmt_NaN;
					break;
				case 'G':
					outfile = &argv[i][2];
					break;

				default:
					error = TRUE;
					gmt_default_error (argv[i][1]);
					break;
			}
		}
		else
			infile = argv[i];
	}
	
	if (gmt_quick || argc == 1) {
		fprintf (stderr, "grdclip %s - Clipping of range in grdfiles\n\n", GMT_VERSION);
		fprintf (stderr, "usage: grdclip <input_grdfile> -G<output_grdfile>\n");
		fprintf (stderr, "\t[-A<high/above>] [-B<low/below>] [-V]\n");
		
		if (gmt_quick) exit (-1);
		
		fprintf (stderr, "\tYou must choose at least one of A or B.\n");
		fprintf (stderr, "\t-G name of output grid.\n");
		fprintf (stderr, "\n\tOPTIONS:\n");
		fprintf (stderr, "\t-A will set all data > high to the <above> value.\n");
		fprintf (stderr, "\t-B will set all data < low to the <below> value.\n");
		fprintf (stderr, "\t   above/below can be any number including gmt_NaN\n");
		explain_option ('V');
		exit (-1);
	}

	if (!outfile) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR -G option:.  Must specify output file\n", gmt_program);
		error++;
	}
	if (!infile) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR:.  Must specify input file\n", gmt_program);
		error++;
	}
	
	if (error) exit (-1);
		
	if (read_grd_info (infile, &header)) {
		fprintf (stderr, "grdclip: Error opening file %s\n", infile);
		exit (-1);
	}
	
	grd_init (&header, argc, argv, TRUE);
	
	nxy = header.nx * header.ny;
	data = (float *) memory (CNULL, nxy, sizeof (float), "grdclip");
	
	if (read_grd (infile, &header, data, 0.0, 0.0, 0.0, 0.0, dummy, FALSE)) {
		fprintf (stderr, "grdclip: Error reading file %s\n", infile);
		exit (-1);
	}
	
	for (i = 0; i < nxy; i++) {
		if (set_above && (!bad_float ((double)data[i])) && data[i] > high) {
			data[i] = above;
			n_above++;
		}
		else if (set_below && (!bad_float ((double)data[i])) && data[i] < low) {
			data[i] = below;
			n_below++;
		}
	}
	
	if (write_grd (outfile, &header, data, 0.0, 0.0, 0.0, 0.0, dummy, FALSE)) {
		fprintf (stderr, "grdclip: Error writing file %s\n", infile);
		exit (-1);
	}
	
	free ((char *) data);

	if (gmtdefs.verbose) {
		if (set_below) fprintf (stderr, "%d values < %g set to %g\n", n_below, low, below);
		if (set_above) fprintf (stderr, "%d values > %g set to %g\n", n_above, high, above);
	}
	
	gmt_end (argc, argv);
}
