/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)grdcut.c	2.14  3/13/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * grdcut.c reads a grdfile and writes a portion within it
 * to a new file.
 *
 * Author:	Walter Smith
 * Date:	5 august, 1988
 *
 */
 
#include "gmt.h"

float	*grd;

main (argc, argv)
int argc;
char **argv;
{
	int	error = FALSE, global = FALSE;
	int	i, nx_old, ny_old, nx_new, ny_new, one_or_zero, dummy[4];
	double	w_new = 0.0, e_new = 0.0, s_new = 0.0, n_new = 0.0;
	double	w_old, e_old, s_old, n_old;
	char *grd_in, *grd_out;
	struct GRD_HEADER header;

	argc = gmt_begin (argc, argv);
	
	grd_in = grd_out = CNULL;
	
	/* Check and interpret the command line arguments */
	
	for (i =1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch(argv[i][1]) {
				/* Common parameters */
			
				case 'R':
				case 'V':
				case '\0':
					error += get_common_args (argv[i], &w_new, &e_new, &s_new, &n_new);
					break;
					
	 			case 'G':
	 				grd_out = &argv[i][2];
					break;
				default:		/* Options not recognized */
					error = TRUE;
					gmt_default_error (argv[i][1]);
					break;
			}
		}
		else
	 		grd_in = argv[i];
	}
	
	if (argc == 1 || gmt_quick) {
		fprintf (stderr,"grdcut %s - Extract subsets from grdfiles\n\n", GMT_VERSION);
		fprintf (stderr, "usage: grdcut <input_grd> -G<output_grd> -R<west/east/south/north> [-V]\n");
		
		if (gmt_quick) exit (-1);
		
		fprintf (stderr, "	<input_grd> is file to extract a subset from.\n");
		fprintf (stderr, "	-G specifies output grdfile\n");
		explain_option ('R');
		fprintf (stderr, "	   Obviously, the WESN you specify must be within the WESN of the input file.\n");
		fprintf (stderr, "	   If in doubt, run grdinfo first and check range of old file.\n");
		fprintf (stderr, "\n\tOPTIONS:\n");
		explain_option ('V');
		exit (-1);
	}

	/* Check that the options selected make sense */
	
	if (!project_info.region_supplied) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR:  Must specify -R option\n", gmt_program);
		error++;
	}
	if (!grd_out) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR -G option:  Must specify output file\n", gmt_program);
		error++;
	}
	if (!grd_in) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR:  Must specify input file\n", gmt_program);
		error++;
	}
	if (error) exit (-1);

	if (read_grd_info (grd_in, &header)) {
		fprintf (stderr, "grdcut: Error opening file %s\n", grd_in);
		exit (-1);
	}
		
	if (s_new < header.y_min || s_new > header.y_max) error = TRUE;
	if (n_new < header.y_min || n_new > header.y_max) error = TRUE;
	global = (fabs (header.x_max - header.x_min) == 360.0);
		
	if ( !global && ((w_new < header.x_min) || (e_new > header.x_max)) ) error = TRUE;
	if (error) {
		fprintf (stderr, "grdcut: Subset exceeds data domain!\n");
		exit (-1);
	}

	grd_init (&header, argc, argv, TRUE);

	w_old = header.x_min;	e_old = header.x_max;
	s_old = header.y_min;	n_old = header.y_max;
	nx_old = header.nx;	ny_old = header.ny;
	one_or_zero = (header.node_offset) ? 0 : 1;
	nx_new = rint ((e_new - w_new) / header.x_inc) + one_or_zero;
	ny_new = rint ((n_new - s_new) / header.y_inc) + one_or_zero;
			
	grd = (float *) memory (CNULL, nx_new * ny_new, sizeof (float), "grdcut");
	dummy[0] = dummy[1] = dummy[2] = dummy[3] = 0;
	if (read_grd (grd_in, &header, grd, w_new, e_new, s_new, n_new, dummy, FALSE)) {
		fprintf (stderr, "grdcut: Error reading file %s\n", grd_in);
		exit (-1);
	}

	if (gmtdefs.verbose) {
		fprintf (stderr, "File spec:\tW E S N dx dy nx ny:\n");
		fprintf (stderr, "Old:\t%.8lg\t%.8lg\t%.8lg\t%.8lg\t%.8lg\t%.8lg\t%d\t%d\n",
			w_old, e_old, s_old, n_old, header.x_inc, header.y_inc, nx_old, ny_old);
		fprintf (stderr, "New:\t%.8lg\t%.8lg\t%.8lg\t%.8lg\t%.8lg\t%.8lg\t%d\t%d\n",
			w_new, e_new, s_new, n_new, header.x_inc, header.y_inc, nx_new, ny_new);
	}

	if (write_grd (grd_out, &header, grd, 0.0, 0.0, 0.0, 0.0, dummy, FALSE)) {
		fprintf (stderr, "grdcut: Error writing file %s\n", grd_out);
		exit (-1);
	}
	
	free ( (char *) grd);
	
	gmt_end (argc, argv);
}
