/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)grdreformat.c	3.11  3/13/95
 *
 *    Copyright (c) 1991-1995 by P. Wessel and W. H. F. Smith
 *    See README file for copying and redistribution conditions.
 *--------------------------------------------------------------------*/
/*
 * grdreformat.c reads a grd file in one format and outputs it in another
 *
 * Author:	Paul Wessel
 * Date:	3-JAN-1991-1995
 * Version:	3.0
 */

#include "gmt.h"

float *z;

main (argc, argv)
int argc;
char **argv; {
	int i, nfiles = 0, nm, nx, ny, one_or_zero, dummy[4];
	int error = FALSE, global = FALSE;
	double w, e, s, n, scale = 1.0, offset = 0.0;
	char *file[2], fname[2][BUFSIZ], line[BUFSIZ];
	struct GRD_HEADER grd;
	FILE *fp;
	char *gmt_data_path;
	argc = gmt_begin (argc, argv);

	w = e = s = n = 0.0;
	dummy[0] = dummy[1] = dummy[2] = dummy[3] = 0;
	
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				/* Common parameters */
			
				case 'R':
				case 'V':
				case '\0':
					error += get_common_args (argv[i], &w, &e, &s, &n);
					break;
					
				default:
					error = TRUE;
					gmt_default_error (argv[i][1]);
					break;
			}
		}
		else if (nfiles < 2) {
			file[nfiles] = argv[i];
			nfiles++;
		}
		else
			nfiles++;
	}
	
	if (argc == 1 || gmt_quick) {	/* Display usage */
		fprintf (stderr, "grdreformat %s - Converting between different grdfile formats\n\n", GMT_VERSION);
		fprintf( stderr, "usage: grdreformat ingrdfile[=id[/scale/offset]] outgrdfile[=id[/scale/offset]] [-Rw/e/s/n] [-V]\n");

		if (gmt_quick) exit (-1);
		
		fprintf (stderr, "	ingrdfile is the grd file to convert\n");
		fprintf (stderr, "	outgrdfile is the new converted grd file\n");
		fprintf( stderr, "	   scale and offset, if given, will multiply data by scale and add offset.\n");
		fprintf (stderr, "\n\tOPTIONS:\n");
		explain_option ('r');
		explain_option ('V');
		
		fprintf (stderr, "	The following formats are supported\n\n");
/*                                                                           */		
/*   Modifications to permit the use of an environmental variable (specified */
/*   in "gmt_os2.h") to point to the directory path.                         */
/*                                                                           */
       gmt_data_path = getenv (GMTDATAPATH);
		sprintf (line, "%s/gmtformats.d\0", gmt_data_path);
      
/*		sprintf (line, "%s/gmtformats.d\0", LIBDIR);    */
		if ((fp = fopen (line, "r")) == NULL) {
			fprintf (stderr, "%s: GMT ERROR: Cannot read file %s\n", gmt_program, line);
			exit (-1);
		}
		while (fgets (line, BUFSIZ, fp)) fprintf (stderr, "\t%s", line);
		fclose (fp);
		exit (-1);
	}
	
	if (nfiles != 2) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR: Must specify both input and output file names\n", gmt_program);
		error++;
	}
	
	if (error) exit (-1);
	
	grd_i_format = grd_get_i_format (file[0], fname[0], &scale, &offset);
	grd_o_format = grd_get_o_format (file[1], fname[1], &scale, &offset);
	
	if (grd_i_format == grd_o_format) {
		fprintf (stderr, "grdreformat: Formats are identical - aborts\n");
		exit (-1);
	}
	
	if (gmtdefs.verbose) {
		if (file[0][0] == '=') strcpy (fname[0], "<stdin>");
		if (file[1][0] == '=') strcpy (fname[1], "<stdout>");
		fprintf (stderr, "grdreformat: Translating file %s (format = %d) to file %s (format = %d)\n", fname[0], grd_i_format, fname[1], grd_o_format);
	}
	
	if (read_grd_info (file[0], &grd)) {
		fprintf (stderr, "grdreformat: Error opening file %s\n", fname[0]);
		exit (-1);
	}
	
	nm = grd.nx * grd.ny;
	
	if (e > w && n > s) {
		global = (fabs (grd.x_max - grd.x_min) == 360.0);
		if (!global && (w < grd.x_min || e > grd.x_max)) error = TRUE;
		if (s < grd.y_min || n > grd.y_max) error = TRUE;
		if (error) {
			fprintf (stderr, "grdreformat: Subset exceeds data domain!\n");
			exit (-1);
		}
		one_or_zero = (grd.node_offset) ? 0 : 1;
		nx = rint ((e - w) / grd.x_inc) + one_or_zero;
		ny = rint ((n - s) / grd.y_inc) + one_or_zero;
		
		z = (float *) memory (CNULL, nx * ny, sizeof (float), "grdreformat");
		
		if (read_grd (file[0], &grd, z, w, e, s, n, dummy, FALSE)) {
			fprintf (stderr, "grdreformat: Error reading file %s\n", fname[0]);
			exit (-1);
		}
	}
	else {
		z = (float *) memory (CNULL, nm, sizeof (float), "grdreformat");

		if (read_grd (file[0], &grd, z, 0.0, 0.0, 0.0, 0.0, dummy, FALSE)) {
			fprintf (stderr, "grdreformat: Error reading file %s\n", fname[0]);
			exit (-1);
		}
	}

	if (write_grd (file[1], &grd, z, 0.0, 0.0, 0.0, 0.0, dummy, FALSE)) {
		fprintf (stderr, "grdreformat: Error writing file %s\n", fname[1]);
		exit (-1);
	}
	
	free ((char *)z);
		
	gmt_end (argc, argv);
}
